/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.plugins;

import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.maven.plugins.ConfigurationElement;
import org.jboss.forge.maven.plugins.ConfigurationElementNotFoundException;
import org.jboss.forge.maven.plugins.PluginElement;

public class ConfigurationElementImpl
implements ConfigurationElement {
    private String name;
    private String text;
    private List<PluginElement> children = new ArrayList<PluginElement>();

    public void setName(String name) {
        this.name = name;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPlugin() {
        return this.name.equals("plugin");
    }

    @Override
    public boolean hasChilderen() {
        return this.children != null && this.children.size() > 0;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void addChild(PluginElement element) {
        this.children.add(element);
    }

    @Override
    public List<PluginElement> getChildren() {
        return this.children;
    }

    public void setChildren(List<PluginElement> children) {
        this.children = children;
    }

    @Override
    public boolean hasChildByContent(String content, boolean directChildsOnly) {
        return this.hasConfigElementByContentRecursive(this, content, FilterType.CONTENT, directChildsOnly);
    }

    @Override
    public boolean hasChildByContent(String content) {
        return this.hasChildByContent(content, false);
    }

    @Override
    public ConfigurationElement getChildByContent(String content, boolean directChildsOnly) {
        return this.getConfigElementRecursiveByContent(this, content, FilterType.CONTENT, directChildsOnly);
    }

    @Override
    public ConfigurationElement getChildByContent(String content) {
        return this.getConfigElementRecursiveByContent(this, content, FilterType.CONTENT, false);
    }

    @Override
    public boolean hasChildByName(String name, boolean directChildsOnly) {
        return this.hasConfigElementByContentRecursive(this, name, FilterType.NAME, directChildsOnly);
    }

    @Override
    public boolean hasChildByName(String name) {
        return this.hasConfigElementByContentRecursive(this, name, FilterType.NAME, false);
    }

    @Override
    public ConfigurationElement getChildByName(String name, boolean directChildsOnly) {
        return this.getConfigElementRecursiveByContent(this, name, FilterType.NAME, directChildsOnly);
    }

    @Override
    public ConfigurationElement getChildByName(String name) {
        return this.getConfigElementRecursiveByContent(this, name, FilterType.NAME, false);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("<").append(this.name).append(">");
        for (PluginElement child : this.children) {
            b.append(child.toString());
        }
        if (this.text != null) {
            b.append(this.text);
        }
        b.append("</").append(this.name).append(">");
        return b.toString();
    }

    private ConfigurationElement getConfigElementRecursiveByContent(ConfigurationElement parent, String filter, FilterType filterType, boolean directChildsOnly) {
        List<PluginElement> children = parent.getChildren();
        for (PluginElement child : children) {
            if (child instanceof ConfigurationElement) {
                ConfigurationElement element = (ConfigurationElement)child;
                if (filterType.equals((Object)FilterType.CONTENT) && filter.equals(element.getText())) {
                    return parent;
                }
                if (filterType.equals((Object)FilterType.NAME) && filter.equals(element.getName())) {
                    return element;
                }
                if (directChildsOnly || !element.hasChilderen()) continue;
                try {
                    return this.getConfigElementRecursiveByContent(element, filter, filterType, directChildsOnly);
                }
                catch (ConfigurationElementNotFoundException configurationElementNotFoundException) {
                    continue;
                }
            }
            throw new RuntimeException("Unexpected type " + child.getClass() + " found as a child of " + parent.getName());
        }
        throw new ConfigurationElementNotFoundException(filter);
    }

    private boolean hasConfigElementByContentRecursive(ConfigurationElement configurationElement, String filter, FilterType filterType, boolean directChildsOnly) {
        try {
            this.getConfigElementRecursiveByContent(configurationElement, filter, filterType, directChildsOnly);
            return true;
        }
        catch (ConfigurationElementNotFoundException ex) {
            return false;
        }
    }

    private static enum FilterType {
        NAME,
        CONTENT;

    }
}

