/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.facets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.build.BuildException;
import org.jboss.forge.project.build.ProjectBuilder;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.resources.Resource;

public class MavenProjectBuilder
implements ProjectBuilder {
    private final ForgeEnvironment environment;
    private final Project project;
    private boolean runTests = true;
    private final List<String> args = new ArrayList<String>();

    @Inject
    public MavenProjectBuilder(ForgeEnvironment environment, Project project) {
        this.environment = environment;
        this.project = project;
    }

    public ProjectBuilder addArguments(String ... args) {
        this.args.addAll(Arrays.asList(args));
        return this;
    }

    public ProjectBuilder runTests(boolean test) {
        this.runTests = test;
        return this;
    }

    public Resource<?> build() {
        boolean success;
        ArrayList<String> selected = new ArrayList<String>();
        selected.addAll(Arrays.asList("clean", "package"));
        if (this.args != null && !this.args.isEmpty()) {
            selected.clear();
            selected.addAll(this.args);
        }
        if (!this.environment.isOnline()) {
            selected.add("--offline");
        }
        if (!this.runTests) {
            selected.add("-DskipTests=true");
            selected.add("-Dmaven.test.skip=true");
        }
        if (success = ((MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class)).executeMaven(selected)) {
            return ((PackagingFacet)this.project.getFacet(PackagingFacet.class)).getFinalArtifact();
        }
        throw new BuildException("Build failed.");
    }
}

