/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.util;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFilter;
import org.jboss.forge.resources.UnknownFileResource;

public class JavaPathspecParser {
    private final JavaSourceFacet java;
    private final String path;
    List<Resource<?>> results = new LinkedList();

    public JavaPathspecParser(JavaSourceFacet java, String path) {
        this.java = java;
        this.path = path == null ? "" : path.trim();
    }

    public List<Resource<?>> resolve(ResourceFilter filter) {
        Resource<File> r = this.java.getSourceFolder();
        String p = this.path;
        if (this.path.startsWith("~")) {
            DirectoryResource base = this.java.getBasePackageResource();
            if (this.path.length() == 1) {
                if (filter.accept(base)) {
                    return JavaPathspecParser.singleResult(base);
                }
            } else {
                r = base;
            }
            if ((p = p.substring(1)).startsWith(".")) {
                p = p.substring(1);
            }
        }
        String[] split = p.split("\\.");
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            if (i == split.length - 1) {
                while (s.endsWith("*")) {
                    s = s.substring(0, s.lastIndexOf("*"));
                }
                if (s.isEmpty()) {
                    this.results.addAll(r.listResources(filter));
                    break;
                }
                List<Resource<?>> resources = r.listResources();
                for (Resource<?> resource : resources) {
                    if (!resource.getName().startsWith(s) || !filter.accept(resource)) continue;
                    this.results.add(resource);
                }
                break;
            }
            Resource<?> child = r.getChild(s);
            if (child instanceof UnknownFileResource) {
                String[] join = new String[split.length - i];
                System.arraycopy(split, i, join, 0, join.length);
                String joined = Strings.join(Arrays.asList(join), (String)".");
                child = r.getChild(joined);
                if (!filter.accept(child)) break;
                this.results.add(child);
                break;
            }
            if (child == null) break;
            r = child;
        }
        return this.results;
    }

    private static List<Resource<?>> singleResult(Resource<?> item) {
        return Collections.singletonList(item);
    }

    public List<? extends Resource<?>> resolve() {
        return this.resolve(new ResourceFilter(){

            @Override
            public boolean accept(Resource<?> resource) {
                return true;
            }
        });
    }
}

