/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.resources.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.MethodHolder;
import org.jboss.forge.parser.java.Parameter;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaMemberResource;
import org.jboss.forge.resources.java.JavaResource;

public class JavaMethodResource
extends JavaMemberResource<Method> {
    private final Method<? extends JavaSource<?>> method;

    public JavaMethodResource(Resource<?> parent, Method<? extends JavaSource<?>> method) {
        super(parent, method);
        this.method = method;
    }

    @Override
    public Resource<Method> createFrom(Method file) {
        throw new RuntimeException("not implemented");
    }

    @Override
    protected List<Resource<?>> doListResources() {
        return Collections.emptyList();
    }

    @Override
    public Method<? extends JavaSource<?>> getUnderlyingResourceObject() {
        return this.method;
    }

    @Override
    public String getName() {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        for (Parameter p : this.method.getParameters()) {
            parameterTypes.add(p.getType());
        }
        String returnType = this.method.getReturnType() == null ? "void" : this.method.getReturnType();
        return String.format("%s(%s)::%s", this.method.getName(), Strings.join(parameterTypes, (String)","), returnType);
    }

    @Override
    public String toString() {
        return this.method.toString();
    }

    @Override
    public boolean delete() throws UnsupportedOperationException {
        JavaSource origin = (JavaSource)this.method.getOrigin();
        if (origin instanceof MethodHolder) {
            ((MethodHolder)origin).removeMethod(this.method);
            if (!((MethodHolder)origin).hasMethodSignature(this.method)) {
                ((JavaResource)this.getParent()).setContents(origin.toString());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean delete(boolean recursive) throws UnsupportedOperationException {
        return this.delete();
    }
}

