/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell;

import java.util.Arrays;
import java.util.List;
import org.jboss.forge.parser.java.util.Strings;

public class PluginEntry {
    private final String name;
    private final String apiVersion;
    private final String slot;

    public PluginEntry(String name, String apiVersion, String slot) {
        this.name = name;
        this.apiVersion = apiVersion;
        this.slot = slot;
    }

    public PluginEntry(String name, String apiVersion) {
        this.name = name;
        this.apiVersion = apiVersion;
        this.slot = null;
    }

    public PluginEntry(String name) {
        this.name = name;
        this.apiVersion = null;
        this.slot = null;
    }

    public String getName() {
        return this.name;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getSlot() {
        return this.slot;
    }

    public String toString() {
        return this.name + ":" + this.apiVersion + ":" + this.slot;
    }

    public static PluginEntry fromCoordinates(String coordinates) {
        String[] split = coordinates.split(":");
        List<String> tokens = Arrays.asList(split);
        if (tokens.size() == 3) {
            if (Strings.isNullOrEmpty((String)tokens.get(0))) {
                throw new IllegalArgumentException("Name was empty [" + coordinates + "]");
            }
            if (Strings.isNullOrEmpty((String)tokens.get(1))) {
                throw new IllegalArgumentException("Version was empty [" + coordinates + "]");
            }
            if (Strings.isNullOrEmpty((String)tokens.get(2))) {
                throw new IllegalArgumentException("Slot was empty [" + coordinates + "]");
            }
            return new PluginEntry(tokens.get(0), tokens.get(1), tokens.get(2));
        }
        throw new IllegalArgumentException("Coordinates must be of the form 'name:apiVersion:slot'");
    }

    public String toModuleId() {
        return this.name + ":" + this.slot;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.apiVersion == null ? 0 : this.apiVersion.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.slot == null ? 0 : this.slot.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PluginEntry other = (PluginEntry)obj;
        if (this.apiVersion == null ? other.apiVersion != null : !this.apiVersion.equals(other.apiVersion)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.slot == null ? other.slot != null : !this.slot.equals(other.slot));
    }

    public String toCoordinates() {
        return this.toString();
    }
}

