/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.util;

import java.io.File;

public final class OSUtils {
    private static boolean PRETEND_WINDOWS = Boolean.getBoolean("forge.pretend_windows");
    private static String operatingSystem = null;

    public static String getOsName() {
        if (operatingSystem == null) {
            operatingSystem = System.getProperty("os.name");
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return PRETEND_WINDOWS || OSUtils.getOsName().startsWith("Windows") || OSUtils.getOsName().startsWith("windows");
    }

    public static boolean isOSX() {
        return OSUtils.getOsName().startsWith("Mac") || OSUtils.getOsName().startsWith("mac");
    }

    public static boolean isLinux() {
        return OSUtils.getOsName().startsWith("Linux") || OSUtils.getOsName().startsWith("linux");
    }

    public static File getUserHomeDir() {
        return new File(System.getProperty("user.home")).getAbsoluteFile();
    }

    public static String getUserHomePath() {
        return OSUtils.getUserHomeDir().getAbsolutePath();
    }

    public static File getDefaultForgeDir() {
        return new File(OSUtils.getUserHomeDir(), ".forge");
    }

    public static String getDefaultForgePath() {
        return OSUtils.getDefaultForgeDir().getAbsolutePath();
    }

    public static void setPretendWindows(boolean value) {
        PRETEND_WINDOWS = value;
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }
}

