/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command.parser;

import java.util.ArrayList;
import java.util.Queue;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.OptionMetadata;
import org.jboss.forge.shell.command.parser.CommandParser;
import org.jboss.forge.shell.command.parser.CommandParserContext;

public class OrderedValueVarargsOptionParser
implements CommandParser {
    @Override
    public CommandParserContext parse(CommandMetadata command, Queue<String> tokens, CommandParserContext ctx) {
        try {
            OptionMetadata option = command.getOrderedOptionByIndex(ctx.getOrderedParamCount());
            if (option.isVarargs()) {
                ArrayList<String> args = new ArrayList<String>();
                String lastToken = null;
                while (!(tokens.isEmpty() || (lastToken = tokens.peek()).startsWith("-") && this.isValidCommandOption(command, lastToken))) {
                    lastToken = tokens.remove();
                    lastToken = Strings.stripQuotes((String)lastToken);
                    args.add(lastToken);
                }
                ctx.put(option, args.toArray(new String[args.size()]), Strings.stripQuotes((String)lastToken));
                ctx.incrementParmCount();
            }
        }
        catch (IllegalArgumentException e) {
            ctx.addWarning("The command [" + command + "] takes [" + command.getNumOrderedOptions() + "] unnamed argument(s), but found [" + (ctx.getOrderedParamCount() + 1) + "].");
        }
        return ctx;
    }

    private boolean isValidCommandOption(CommandMetadata command, String lastToken) {
        String name = lastToken.replaceAll("^--?", "");
        for (OptionMetadata option : command.getOptions()) {
            if (!option.isNamed() || !option.getName().startsWith(name) && (option.getShortName().isEmpty() || !option.getShortName().startsWith(name))) continue;
            return true;
        }
        return false;
    }
}

