/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.completer;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.shell.completer.CommandCompleter;
import org.jboss.forge.shell.completer.CommandCompleterState;
import org.jboss.forge.shell.completer.CommandResolverCompleter;
import org.jboss.forge.shell.completer.CompletedCommandHolder;
import org.jboss.forge.shell.completer.OptionResolverCompleter;
import org.jboss.forge.shell.completer.OptionValueResolverCompleter;
import org.jboss.forge.shell.completer.PluginCommandCompleterState;
import org.jboss.forge.shell.completer.PluginResolverCompleter;
import org.jboss.forge.shell.console.jline.console.completer.Completer;

@Singleton
public class PluginCommandCompleter
implements Completer {
    List<CommandCompleter> completers = new ArrayList<CommandCompleter>();
    private String lastBuffer = null;
    private final CompletedCommandHolder optionHolder;

    @Inject
    public PluginCommandCompleter(PluginResolverCompleter plugin, CommandResolverCompleter command, OptionResolverCompleter option, OptionValueResolverCompleter value, CompletedCommandHolder optionHolder) {
        this.optionHolder = optionHolder;
        this.completers.add(plugin);
        this.completers.add(command);
        this.completers.add(option);
        this.completers.add(value);
    }

    @Override
    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        this.optionHolder.setState(null);
        PluginCommandCompleterState state = new PluginCommandCompleterState(buffer, this.lastBuffer, cursor);
        this.lastBuffer = buffer;
        for (CommandCompleter c : this.completers) {
            if (state.hasSuggestions()) continue;
            c.complete((CommandCompleterState)state);
        }
        candidates.addAll(state.getCandidates());
        if (state.getPlugin() != null && state.isFinalTokenComplete() && !state.hasSuggestions() && state.isDuplicateBuffer() && state.getCandidates().isEmpty()) {
            candidates.add("");
        }
        this.optionHolder.setState(state);
        return state.getIndex();
    }

    public static boolean isPotentialMatch(String full, String partial) {
        return full.matches("(?i)" + partial + ".*");
    }
}

