/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.observers;

import javax.enterprise.event.Observes;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.events.PreCommandExecution;

public class DeprecatedObserver {
    public void beforeCommandExecution(@Observes PreCommandExecution cmd, Shell shell) {
        CommandMetadata command = cmd.getCommand();
        boolean deprecated = command.getMethod().isAnnotationPresent(Deprecated.class);
        if (deprecated) {
            String message = String.format("The command (%s) is deprecated and may be removed in future versions", command.getName());
            ShellMessages.warn((ShellPrintWriter)shell, (String)message);
        }
    }
}

