/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeIn;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.util.GeneralUtils;

@Alias(value="wc")
@Topic(value="File & Resources")
@Help(value="word, line, character and byte count")
public class WordCountPlugin
implements Plugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultCommand
    public void run(@PipeIn InputStream pipeIn, @Option(name="lines", shortName="l", flagOnly=true) boolean lineCount, @Option(name="words", shortName="w", flagOnly=true) boolean wordCount, @Option(name="characters", shortName="c", flagOnly=true) boolean charCount, @Option(description="file ...", required=false) Resource<?>[] resources, PipeOut out) throws IOException {
        if (!(lineCount || wordCount || charCount)) {
            wordCount = true;
        }
        if (resources != null) {
            ArrayList<String> results = new ArrayList<String>();
            for (Resource<?> r : resources) {
                if (r instanceof DirectoryResource) {
                    System.err.println("wc: " + r.getName() + ": is a directory.");
                    continue;
                }
                InputStream instream = r.getResourceInputStream();
                try {
                    Results countResults = WordCountPlugin.count(instream, lineCount, wordCount, charCount);
                    results.addAll(countResults.getResults(r.getName()));
                }
                finally {
                    instream.close();
                }
            }
            Results x = new Results();
            x.countLines = lineCount;
            x.countWords = wordCount;
            x.countChars = charCount;
            WordCountPlugin.printOutResults(out, x.getColumns(), results);
        } else if (pipeIn != null) {
            Results countResults = WordCountPlugin.count(pipeIn, lineCount, wordCount, charCount);
            WordCountPlugin.printOutResults(out, countResults.getColumns(), countResults.getResults("<pipe>"));
        }
    }

    private static void printOutResults(PipeOut out, int cols, List<String> results) {
        boolean[] colJust = new boolean[cols];
        for (int i = 0; i < cols; ++i) {
            colJust[i] = true;
        }
        colJust[cols - 1] = false;
        GeneralUtils.printOutTables(results, colJust, (ShellPrintWriter)out, null);
    }

    private static Results count(InputStream stream, boolean lines, boolean words, boolean chars) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        Results res = new Results();
        res.countLines = lines;
        res.countWords = words;
        res.countChars = chars;
        boolean capture = false;
        while ((read = stream.read(buffer)) != -1) {
            res.characters += read;
            for (int i = 0; i < read; ++i) {
                int c = buffer[i];
                if (Character.isWhitespace(c)) {
                    if (capture) {
                        capture = false;
                        ++res.words;
                    }
                    if (c == 13 && i + 1 < read && buffer[i + 1] == 10) {
                        ++i;
                        c = 10;
                    }
                    if (c != 10) continue;
                    ++res.lines;
                    continue;
                }
                capture = true;
            }
        }
        return res;
    }

    private static class Results {
        int words;
        int characters;
        int lines;
        boolean countWords;
        boolean countChars;
        boolean countLines;

        private Results() {
        }

        int getColumns() {
            int cols = this.countWords ? 1 : 0;
            cols += this.countChars ? 1 : 0;
            return (cols += this.countLines ? 1 : 0) + 1;
        }

        public int getValue(int index) {
            switch (index) {
                case 0: {
                    if (this.countLines) {
                        return this.lines;
                    }
                }
                case 1: {
                    if (this.countWords) {
                        return this.words;
                    }
                }
                case 2: {
                    if (!this.countChars) break;
                    return this.characters;
                }
            }
            return 0;
        }

        List<String> getResults(String name) {
            int cols = this.getColumns();
            ArrayList<String> results = new ArrayList<String>(cols);
            for (int i = 0; i < cols - 1; ++i) {
                results.add("    " + String.valueOf(this.getValue(i)));
            }
            results.add(name);
            return results;
        }
    }
}

