/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.AbstractShellPrompt;
import org.jboss.forge.shell.IdeTerminal;
import org.jboss.forge.shell.IgnoreEofKeyListener;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellConfig;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.SigHandler;
import org.jboss.forge.shell.buffers.ConsoleInputSession;
import org.jboss.forge.shell.buffers.JLineScreenBuffer;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.PluginMetadata;
import org.jboss.forge.shell.command.PromptTypeConverter;
import org.jboss.forge.shell.command.convert.BooleanConverter;
import org.jboss.forge.shell.command.convert.DependencyIdConverter;
import org.jboss.forge.shell.command.convert.FileConverter;
import org.jboss.forge.shell.command.convert.URLConverter;
import org.jboss.forge.shell.command.fshparser.FSHRuntime;
import org.jboss.forge.shell.completer.CompletedCommandHolder;
import org.jboss.forge.shell.completer.OptionAwareCompletionHandler;
import org.jboss.forge.shell.completer.PluginCommandCompleter;
import org.jboss.forge.shell.console.jline.Terminal;
import org.jboss.forge.shell.console.jline.TerminalFactory;
import org.jboss.forge.shell.console.jline.console.ConsoleReader;
import org.jboss.forge.shell.console.jline.console.completer.AggregateCompleter;
import org.jboss.forge.shell.console.jline.console.completer.Completer;
import org.jboss.forge.shell.console.jline.console.history.MemoryHistory;
import org.jboss.forge.shell.events.AcceptUserInput;
import org.jboss.forge.shell.events.PreShutdown;
import org.jboss.forge.shell.events.Shutdown;
import org.jboss.forge.shell.events.Startup;
import org.jboss.forge.shell.exceptions.AbortedException;
import org.jboss.forge.shell.exceptions.CommandExecutionException;
import org.jboss.forge.shell.exceptions.CommandParserException;
import org.jboss.forge.shell.exceptions.EndOfStreamException;
import org.jboss.forge.shell.exceptions.PluginExecutionException;
import org.jboss.forge.shell.exceptions.ShellExecutionException;
import org.jboss.forge.shell.integration.BufferManager;
import org.jboss.forge.shell.integration.KeyListener;
import org.jboss.forge.shell.plugins.builtin.Echo;
import org.jboss.forge.shell.project.CurrentProject;
import org.jboss.forge.shell.spi.CommandInterceptor;
import org.jboss.forge.shell.spi.TriggeredAction;
import org.jboss.forge.shell.util.Booleans;
import org.jboss.forge.shell.util.Files;
import org.jboss.forge.shell.util.GeneralUtils;
import org.jboss.forge.shell.util.JavaPathspecParser;
import org.jboss.forge.shell.util.OSUtils;
import org.jboss.forge.shell.util.ResourceUtil;
import org.jboss.forge.shell.util.Streams;
import org.jboss.weld.environment.se.bindings.Parameters;
import org.mvel2.ConversionHandler;
import org.mvel2.DataConversion;

@ApplicationScoped
public class ShellImpl
extends AbstractShellPrompt
implements Shell {
    static final String DEFAULT_PROMPT = "[\\c{green}$PROJECT_NAME\\c] \\c{blue}\\W\\c \\c{green}\\$\\c ";
    static final String DEFAULT_PROMPT_NO_PROJ = "[\\c{red}no project\\c] \\c{blue}\\W\\c \\c{red}\\$\\c ";
    public static final String PROP_FORGE_CONFIG_DIR = "FORGE_CONFIG_DIR";
    public static final String PROP_PROMPT = "PROMPT";
    public static final String PROP_PROMPT_NO_PROJ = "PROMPT_NOPROJ";
    public static final String PROP_DEFAULT_PLUGIN_REPO = "DEFAULT_PLUGIN_REPO";
    public static final String DEFAULT_PLUGIN_REPO = "https://raw.github.com/forge/plugin-repository/master/repository.yaml";
    private static final String PROP_ACCEPT_DEFAULTS = "ACCEPT_DEFAULTS";
    public static final String PROP_VERBOSE = "VERBOSE";
    public static final String PROP_HISTORY = "HISTORY";
    public static final String PROP_EXCEPTION_HANDLING = "EXCEPTION_HANDLING";
    public static final String PROP_FORGE_VERSION = "FORGE_VERSION";
    static final String NO_INIT_SYSTEM_PROPERTY = "forge.debug.no_auto_init_streams";
    static final String FORGE_HOME_SYSTEM_PROPERTY = "forge.home";
    static final String PROP_IGNORE_EOF = "IGNOREEOF";
    static final int DEFAULT_IGNORE_EOF = 1;
    public static final String FORGE_CONFIG_DIR = System.getProperty("FORGE_CONFIG_DIR", OSUtils.getDefaultForgePath());
    public static final String FORGE_COMMAND_HISTORY_FILE = "cmd_history";
    public static final String FORGE_CONFIG_FILE = "config";
    public static final String OFFLINE_FLAG = "OFFLINE";
    @Inject
    @Parameters
    private List<String> parameters;
    @Inject
    private BeanManager manager;
    @Inject
    private CurrentProject projectContext;
    @Inject
    ResourceFactory resourceFactory;
    private Resource<?> lastResource;
    @Inject
    private FSHRuntime fshRuntime;
    @Inject
    PromptTypeConverter promptTypeConverter;
    @Inject
    private CompletedCommandHolder commandHolder;
    @Inject
    private ForgeEnvironment environment;
    private ConsoleReader reader;
    private Completer completer;
    private boolean pretend = false;
    private boolean exitRequested = false;
    private ConsoleInputSession inputPipe;
    private OutputStream outputStream;
    private OutputStream historyOutstream;
    private BufferManager screenBuffer;
    private InputStream _redirectedStream;
    private List<String> _historyOverride;
    private final BufferingMode bufferingMode = BufferingMode.Direct;
    private final boolean colorEnabled = Boolean.getBoolean("forge.shell.colorEnabled");
    private final ConversionHandler resourceConversionHandler = new ConversionHandler(){

        public Resource[] convertFrom(Object obl) {
            String[] stringArray;
            ResourceFactory resourceFactory = ShellImpl.this.resourceFactory;
            Resource resource = ShellImpl.this.lastResource;
            Resource<?> resource2 = ShellImpl.this.getCurrentResource();
            if (obl instanceof String[]) {
                stringArray = (String[])obl;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = obl.toString();
            }
            return GeneralUtils.parseSystemPathspec(resourceFactory, resource, resource2, stringArray);
        }

        public boolean canConvertFrom(Class aClass) {
            return true;
        }
    };
    private final ConversionHandler javaResourceConversionHandler = new ConversionHandler(){

        public JavaResource[] convertFrom(Object obj) {
            if (ShellImpl.this.getCurrentProject().hasFacet(JavaSourceFacet.class)) {
                String[] stringArray;
                if (obj instanceof String[]) {
                    stringArray = (String[])obj;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = obj.toString();
                }
                String[] strings = stringArray;
                ArrayList resources = new ArrayList();
                for (String string : strings) {
                    resources.addAll(new JavaPathspecParser((JavaSourceFacet)ShellImpl.this.getCurrentProject().getFacet(JavaSourceFacet.class), string).resolve());
                }
                ArrayList<JavaResource> filtered = new ArrayList<JavaResource>();
                for (Resource resource : resources) {
                    if (!(resource instanceof JavaResource)) continue;
                    filtered.add((JavaResource)resource);
                }
                JavaResource[] result = new JavaResource[filtered.size()];
                result = filtered.toArray(result);
                return result;
            }
            return null;
        }

        public boolean canConvertFrom(Class aClass) {
            return true;
        }
    };
    private boolean executing;
    @Inject
    private ShellConfig shellConfig;
    @Inject
    private Instance<CommandInterceptor> commandInterceptors;
    @Inject
    private Instance<TriggeredAction> triggeredActions;
    @Inject
    private IgnoreEofKeyListener ignoreEOF;
    private final Object executorLock = new Object();
    private volatile Thread executorThread;
    private volatile boolean interruptedState = false;

    void init(@Observes Startup event, PluginCommandCompleter pluginCompleter) throws Exception {
        BooleanConverter booleanConverter = new BooleanConverter();
        DataConversion.addConversionHandler(Boolean.TYPE, (ConversionHandler)booleanConverter);
        DataConversion.addConversionHandler(Boolean.class, (ConversionHandler)booleanConverter);
        DataConversion.addConversionHandler(File.class, (ConversionHandler)new FileConverter());
        DataConversion.addConversionHandler(Dependency.class, (ConversionHandler)new DependencyIdConverter());
        DataConversion.addConversionHandler(URL.class, (ConversionHandler)new URLConverter());
        DataConversion.addConversionHandler(JavaResource[].class, (ConversionHandler)this.javaResourceConversionHandler);
        DataConversion.addConversionHandler(JavaResource.class, (ConversionHandler)new ConversionHandler(){

            public Object convertFrom(Object obj) {
                JavaResource[] res = (JavaResource[])ShellImpl.this.javaResourceConversionHandler.convertFrom(obj);
                if (res.length > 1) {
                    throw new RuntimeException("ambiguous paths");
                }
                if (res.length == 0) {
                    if (ShellImpl.this.getCurrentProject().hasFacet(JavaSourceFacet.class)) {
                        JavaSourceFacet java = (JavaSourceFacet)ShellImpl.this.getCurrentProject().getFacet(JavaSourceFacet.class);
                        try {
                            JavaResource resource = java.getJavaResource(obj.toString());
                            return resource;
                        }
                        catch (FileNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return null;
                }
                return res[0];
            }

            public boolean canConvertFrom(Class type) {
                return ShellImpl.this.javaResourceConversionHandler.canConvertFrom(type);
            }
        });
        DataConversion.addConversionHandler(Resource[].class, (ConversionHandler)this.resourceConversionHandler);
        DataConversion.addConversionHandler(Resource.class, (ConversionHandler)new ConversionHandler(){

            public Object convertFrom(Object o) {
                Resource[] res = (Resource[])ShellImpl.this.resourceConversionHandler.convertFrom(o);
                if (res.length > 1) {
                    throw new RuntimeException("ambiguous paths");
                }
                if (res.length == 0) {
                    return ResourceUtil.parsePathspec((ResourceFactory)ShellImpl.this.resourceFactory, ShellImpl.this.getCurrentResource(), (String)o.toString()).get(0);
                }
                return res[0];
            }

            public boolean canConvertFrom(Class aClass) {
                return ShellImpl.this.resourceConversionHandler.canConvertFrom(aClass);
            }
        });
        this.configureOSTerminal();
        this.completer = new AggregateCompleter(pluginCompleter);
        this.initReaderAndStreams();
        this.initParameters();
        if (event.isRestart()) {
            this.environment.setProperty("NO_MOTD", (Object)true);
        } else {
            this.environment.setProperty("NO_MOTD", (Object)false);
        }
        this.environment.setProperty("OS_NAME", (Object)OSUtils.getOsName());
        this.environment.setProperty(PROP_FORGE_CONFIG_DIR, (Object)FORGE_CONFIG_DIR);
        this.environment.setProperty(PROP_PROMPT, (Object)"> ");
        this.environment.setProperty(PROP_PROMPT_NO_PROJ, (Object)"> ");
        if (Boolean.getBoolean("forge.offline")) {
            this.environment.setProperty(OFFLINE_FLAG, (Object)true);
        } else {
            this.environment.setProperty(OFFLINE_FLAG, (Object)false);
        }
        this.shellConfig.loadHistory(this);
        this.shellConfig.loadConfig(this);
        this.initSignalHandlers();
        if (!this.isNoInitMode()) {
            this.registerKeyListener(this.ignoreEOF);
        }
        this.projectContext.setCurrentResource(this.resourceFactory.getResourceFrom(event.getWorkingDirectory()));
        this.environment.setProperty("CWD", (Object)this.getCurrentDirectory().getFullyQualifiedName());
        this.environment.setProperty("SHELL", (Object)this);
    }

    private void initSignalHandlers() {
        try {
            Class.forName("sun.misc.SignalHandler");
            SigHandler.init(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void writeToHistory(String command) {
        if (this.isHistoryEnabled()) {
            try {
                for (int i = 0; i < command.length(); ++i) {
                    this.historyOutstream.write(command.charAt(i));
                }
                this.historyOutstream.write(OSUtils.getLineSeparator().getBytes());
                this.historyOutstream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isHistoryEnabled() {
        Object s = this.environment.getProperty(PROP_HISTORY);
        return Booleans.toBooleanValue(s);
    }

    public void setHistoryEnabled(boolean verbose) {
        this.environment.setProperty(PROP_VERBOSE, (Object)String.valueOf(verbose));
    }

    public boolean isAcceptDefaults() {
        Object s = this.environment.getProperty(PROP_ACCEPT_DEFAULTS);
        return Booleans.toBooleanValue(s);
    }

    public void setAcceptDefaults(boolean accept) {
        this.environment.setProperty(PROP_ACCEPT_DEFAULTS, (Object)accept);
    }

    public void setHistoryOutputStream(OutputStream stream) {
        this.historyOutstream = stream;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    ShellImpl.this.historyOutstream.flush();
                    ShellImpl.this.historyOutstream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void setHistory(List<String> lines) {
        if (this.isNoInitMode()) {
            this._historyOverride = lines;
            return;
        }
        this._setHistory(lines);
    }

    private void _setHistory(List<String> lines) {
        MemoryHistory history = new MemoryHistory();
        for (String line : lines) {
            history.add(line);
        }
        this.reader.setHistory(history);
    }

    boolean isNoInitMode() {
        return Boolean.getBoolean(NO_INIT_SYSTEM_PROPERTY);
    }

    private void initReaderAndStreams() throws IOException {
        Terminal terminal;
        boolean noInitMode = this.isNoInitMode();
        if (this._redirectedStream == null && noInitMode) {
            return;
        }
        if (this.inputPipe == null && this._redirectedStream == null) {
            this.inputPipe = new ConsoleInputSession(System.in, this.environment.isEmbedded());
        }
        if (this.outputStream == null) {
            this.outputStream = System.out;
        }
        if (this.environment.isEmbedded()) {
            terminal = new IdeTerminal();
        } else if (OSUtils.isWindows()) {
            OutputStream ansiOut = AnsiConsole.wrapOutputStream((OutputStream)this.outputStream);
            TerminalFactory.configure(TerminalFactory.Type.WINDOWS);
            terminal = TerminalFactory.get();
            final OutputStreamWriter writer = new OutputStreamWriter(ansiOut, System.getProperty("jline.WindowsTerminal.output.encoding", System.getProperty("file.encoding")));
            this.outputStream = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    writer.write(b);
                    writer.flush();
                }
            };
        } else {
            terminal = TerminalFactory.get();
        }
        this.screenBuffer = new JLineScreenBuffer(terminal, this.outputStream);
        this.reader = new ConsoleReader(this._redirectedStream == null ? this.inputPipe.getExternalInputStream() : this._redirectedStream, this, null, terminal);
        this.reader.setHistoryEnabled(true);
        this.reader.setBellEnabled(false);
        for (TriggeredAction action : this.triggeredActions) {
            this.reader.addTriggeredAction(action.getTrigger(), action.getListener());
        }
        if (noInitMode && this._historyOverride != null) {
            this._setHistory(this._historyOverride);
        }
        this.reader.addCompleter(this.completer);
        this.reader.setCompletionHandler(new OptionAwareCompletionHandler(this.commandHolder, this));
    }

    private void initParameters() {
        if (!this.isVerbose()) {
            this.environment.setProperty(PROP_VERBOSE, (Object)String.valueOf(this.parameters.contains("--verbose")));
        }
        this.environment.setProperty(PROP_EXCEPTION_HANDLING, (Object)String.valueOf(!this.parameters.contains("--disableExceptionHandlers")));
        if (this.parameters.contains("--pretend")) {
            this.pretend = true;
        }
        if (this.parameters == null || !this.parameters.isEmpty()) {
            // empty if block
        }
    }

    void teardown(@Observes Shutdown shutdown, Event<PreShutdown> preShutdown) {
        preShutdown.fire((Object)new PreShutdown(shutdown.getStatus()));
        this.exitRequested = true;
        if (this.inputPipe != null) {
            this.inputPipe.stop();
        }
    }

    void doShell(@Observes AcceptUserInput event) throws Exception {
        this.reader.setPrompt(this.getPrompt());
        while (!this.exitRequested) {
            try {
                String line = this.readLine();
                if (line == null) continue;
                if (!"".equals(line.trim())) {
                    this.writeToHistory(line);
                    this.execute(line);
                    this.flush();
                }
                this.reader.setPrompt(this.getPrompt());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void handleException(Exception original) throws Exception {
        if (!this.isExceptionHandlingEnabled()) {
            Throwable root = original;
            while (root.getCause() != null && !root.getCause().equals(root)) {
                root = root.getCause();
            }
            if (root instanceof Exception) {
                throw root;
            }
            throw new RuntimeException(root);
        }
        try {
            Throwable cause = original;
            while (cause.getCause() != null) {
                if (cause instanceof AbortedException) {
                    throw (AbortedException)cause;
                }
                cause = cause.getCause();
            }
            throw cause;
        }
        catch (AbortedException e) {
            ShellMessages.info((ShellPrintWriter)this, (String)"Aborted.");
            if (this.isVerbose()) {
                e.printStackTrace();
            }
        }
        catch (CommandExecutionException e) {
            ShellMessages.error((ShellPrintWriter)this, (String)(this.formatSourcedError(e.getCommand()) + e.getMessage()));
            if (this.isVerbose()) {
                e.printStackTrace();
            }
        }
        catch (CommandParserException e) {
            ShellMessages.error((ShellPrintWriter)this, (String)(this.formatSourcedError(e.getCommand()) + e.getMessage()));
            if (this.isVerbose()) {
                e.printStackTrace();
            }
        }
        catch (PluginExecutionException e) {
            ShellMessages.error((ShellPrintWriter)this, (String)(this.formatSourcedError(e.getPlugin()) + e.getMessage()));
            if (this.isVerbose()) {
                e.printStackTrace();
            }
        }
        catch (ShellExecutionException e) {
            ShellMessages.error((ShellPrintWriter)this, (String)e.getMessage());
            if (this.isVerbose()) {
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            if (!this.isVerbose()) {
                ShellMessages.error((ShellPrintWriter)this, (String)("Exception encountered: " + e.getMessage() + " (type \"set VERBOSE true\" to enable stack traces)"));
            }
            ShellMessages.error((ShellPrintWriter)this, (String)"Exception encountered: (type \"set VERBOSE false\" to disable stack traces)");
            e.printStackTrace();
        }
    }

    private String formatSourcedError(PluginMetadata plugin) {
        return plugin == null ? "" : "[" + plugin.toString() + "] ";
    }

    private String formatSourcedError(CommandMetadata cmd) {
        String out;
        if (cmd != null) {
            out = cmd.getParent().getName();
            if (!cmd.isDefault()) {
                out = out + " " + cmd.getName();
            }
            out = "[" + out + "] ";
        } else {
            out = "";
        }
        return out;
    }

    public String readLine() throws IOException {
        return this.readLine(null);
    }

    public String readLine(Character mask) throws IOException {
        String line = mask != null ? this.reader.readLine(mask) : this.reader.readLine();
        if (line != null && !OSUtils.getLineSeparator().equals(line)) {
            this.write(OSUtils.getLineSeparator().getBytes());
        }
        this.flush();
        return line;
    }

    public int scan() {
        try {
            return this.reader.readVirtualKey();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public void clearLine() {
        this.print(new Ansi().eraseLine(Ansi.Erase.ALL).toString());
    }

    public void cursorLeft(int x) {
        this.print(new Ansi().cursorLeft(x).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String line) throws Exception {
        Object object = this.executorLock;
        synchronized (object) {
            try {
                this.executing = true;
                if (!this.interruptedState) {
                    for (CommandInterceptor interceptor : this.commandInterceptors) {
                        line = interceptor.intercept(line);
                    }
                    this.executorThread = new ExecutorThread(line);
                    this.executorThread.run();
                    this.executorThread.join();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            finally {
                this.executing = false;
                this.interruptedState = false;
            }
        }
    }

    public void interrupt() {
        if (this.executorThread != null) {
            this.executorThread.interrupt();
            try {
                this.inputPipe.interruptPipe();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.print("[killed]");
            this.interruptedState = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(File file) throws Exception {
        StringBuilder buf = new StringBuilder();
        BufferedInputStream instream = new BufferedInputStream(new FileInputStream(file));
        try {
            int read;
            byte[] b = new byte[25];
            while ((read = ((InputStream)instream).read(b)) != -1) {
                for (int i = 0; i < read; ++i) {
                    buf.append((char)b[i]);
                }
            }
            ((InputStream)instream).close();
            this.execute(buf.toString());
        }
        finally {
            this.ignoreEOF.reset();
            ((InputStream)instream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(File file, String ... args) throws Exception {
        int i;
        StringBuilder buf = new StringBuilder();
        String funcName = (file.getName().replaceAll("\\.", "_") + "_" + this.hashCode()).replaceAll("\\-", "M");
        buf.append("def ").append(funcName).append('(');
        if (args != null) {
            for (i = 0; i < args.length; ++i) {
                buf.append("_").append(i);
                if (i + 1 >= args.length) continue;
                buf.append(", ");
            }
        }
        buf.append(") {\n");
        if (args != null) {
            buf.append("@_vararg = new String[").append(args.length).append("];\n");
            for (i = 0; i < args.length; ++i) {
                buf.append("@_vararg[").append(i).append("] = ").append("_").append(i).append(";\n");
            }
        }
        BufferedInputStream instream = new BufferedInputStream(new FileInputStream(file));
        try {
            buf.append(Streams.toString((InputStream)instream));
            buf.append("\n}; \n@").append(funcName).append('(');
            if (args != null) {
                for (int i2 = 0; i2 < args.length; ++i2) {
                    buf.append("\"").append(args[i2].replaceAll("\\\"", "\\\\\\\"")).append("\"");
                    if (i2 + 1 >= args.length) continue;
                    buf.append(", ");
                }
            }
            buf.append(");\n");
            this.execute(buf.toString());
        }
        finally {
            this.environment.removeProperty(funcName);
            ((InputStream)instream).close();
        }
    }

    public void printlnVerbose(String line) {
        if (line != null && this.isVerbose()) {
            this.screenBuffer.write(OSUtils.getLineSeparator().getBytes());
        }
    }

    public void print(String output) {
        if (output != null) {
            this.screenBuffer.write(output);
        }
    }

    public void println(String line) {
        if (line != null) {
            this.screenBuffer.write(line);
            this.screenBuffer.write(OSUtils.getLineSeparator().getBytes());
        }
    }

    public void println() {
        try {
            this.screenBuffer.write(OSUtils.getLineSeparator().getBytes());
            this._flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void print(ShellColor color, String output) {
        this.print(this.renderColor(color, output));
    }

    public void println(ShellColor color, String output) {
        this.println(this.renderColor(color, output));
    }

    public void printlnVerbose(ShellColor color, String output) {
        this.printlnVerbose(this.renderColor(color, output));
    }

    public String renderColor(ShellColor color, String output) {
        if (!this.colorEnabled) {
            return output;
        }
        Ansi ansi = new Ansi();
        if (OSUtils.isWindows() && !this.environment.isEmbedded()) {
            ansi.a(Ansi.Attribute.INTENSITY_BOLD);
        }
        switch (color) {
            case BLACK: {
                ansi.fg(Ansi.Color.BLACK);
                break;
            }
            case BLUE: {
                ansi.fg(Ansi.Color.BLUE);
                break;
            }
            case CYAN: {
                ansi.fg(Ansi.Color.CYAN);
                break;
            }
            case GREEN: {
                ansi.fg(Ansi.Color.GREEN);
                break;
            }
            case MAGENTA: {
                ansi.fg(Ansi.Color.MAGENTA);
                break;
            }
            case RED: {
                ansi.fg(Ansi.Color.RED);
                break;
            }
            case WHITE: {
                ansi.fg(Ansi.Color.WHITE);
                break;
            }
            case YELLOW: {
                ansi.fg(Ansi.Color.YELLOW);
                break;
            }
            case BOLD: {
                ansi.a(Ansi.Attribute.INTENSITY_BOLD);
                break;
            }
            case ITALIC: {
                ansi.a(Ansi.Attribute.ITALIC);
                ansi.a(Ansi.Attribute.INTENSITY_FAINT);
                break;
            }
            case UNDERLINE: {
                ansi.a(Ansi.Attribute.UNDERLINE);
                break;
            }
            case STRIKEOUT: {
                ansi.a(Ansi.Attribute.STRIKETHROUGH_ON);
                break;
            }
            default: {
                return output;
            }
        }
        return ansi.render(output).reset().toString();
    }

    public void write(int b) {
        this.screenBuffer.write(b);
    }

    public synchronized void write(byte b) {
        this.screenBuffer.write(b);
    }

    public void write(byte[] b) {
        this.screenBuffer.write(b);
    }

    public void write(byte[] b, int offset, int length) {
        this.screenBuffer.write(b, offset, length);
    }

    private void _flushBuffer() throws IOException {
        if (this.bufferingMode == BufferingMode.Direct) {
            this.reader.flush();
        }
    }

    public void clear() {
        this.print(new Ansi().cursor(0, 0).eraseScreen().toString());
    }

    public boolean isExceptionHandlingEnabled() {
        Object s = this.environment.getProperty(PROP_EXCEPTION_HANDLING);
        return Booleans.toBooleanValue(s);
    }

    public void setExceptionHandlingEnabled(boolean enabled) {
        this.environment.setProperty(PROP_EXCEPTION_HANDLING, (Object)String.valueOf(enabled));
    }

    public boolean isVerbose() {
        Object s = this.environment.getProperty(PROP_VERBOSE);
        return Booleans.toBooleanValue(s);
    }

    public void setVerbose(boolean verbose) {
        this.environment.setProperty(PROP_VERBOSE, (Object)String.valueOf(verbose));
    }

    public boolean isPretend() {
        return this.pretend;
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void setInputStream(InputStream is) throws IOException {
        this.inputPipe = null;
        this._redirectedStream = is;
        this.initReaderAndStreams();
    }

    public void setOutputStream(OutputStream stream) throws IOException {
        this.outputStream = stream;
        this.initReaderAndStreams();
    }

    public void setDefaultPrompt() {
        this.setPrompt("");
    }

    public void setPrompt(String prompt) {
        this.environment.setProperty(PROP_PROMPT, (Object)prompt);
    }

    public String getPrompt() {
        if (this.projectContext.getCurrent() != null) {
            return Echo.echo(this, Echo.promptExpressionParser(this, (String)this.environment.getProperty(PROP_PROMPT)));
        }
        return Echo.echo(this, Echo.promptExpressionParser(this, (String)this.environment.getProperty(PROP_PROMPT_NO_PROJ)));
    }

    public DirectoryResource getCurrentDirectory() {
        Resource<?> r = this.getCurrentResource();
        return ResourceUtil.getContextDirectory(r);
    }

    public DirectoryResource getConfigDir() {
        return (DirectoryResource)this.resourceFactory.getResourceFrom(new File((String)this.environment.getProperty(PROP_FORGE_CONFIG_DIR))).reify(DirectoryResource.class);
    }

    public Resource<?> getCurrentResource() {
        Resource result = this.projectContext.getCurrentResource();
        if (result == null) {
            result = this.resourceFactory.getResourceFrom(Files.getWorkingDirectory());
            this.environment.setProperty("CWD", (Object)result.getFullyQualifiedName());
        }
        return result;
    }

    public Class<? extends Resource<?>> getCurrentResourceScope() {
        return this.getCurrentResource().getClass();
    }

    public void setCurrentResource(Resource<?> resource) {
        this.lastResource = this.getCurrentResource();
        this.projectContext.setCurrentResource(resource);
        this.environment.setProperty("CWD", (Object)resource.getFullyQualifiedName());
    }

    public Project getCurrentProject() {
        return this.projectContext.getCurrent();
    }

    public int getHeight() {
        return this.screenBuffer.getHeight();
    }

    public int getAbsoluteHeight() {
        return this.reader.getTerminal().getHeight();
    }

    public int getWidth() {
        return this.screenBuffer.getWidth();
    }

    public String escapeCode(int code, String value) {
        return new Ansi().a(value).fg(Ansi.Color.BLUE).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String promptWithCompleter(String message, Completer tempCompleter) {
        Object object = this.executorLock;
        synchronized (object) {
            if (!message.isEmpty() && message.matches("^.*\\S$")) {
                message = message + " ";
            }
            message = this.renderColor(ShellColor.CYAN, " ? ") + message;
            try {
                ReturnValueThread thread;
                this.reader.removeCompleter(this.completer);
                if (tempCompleter != null) {
                    this.reader.addCompleter(tempCompleter);
                }
                this.reader.setHistoryEnabled(false);
                this.reader.setPrompt(message);
                this.flush();
                Callable<String> call = new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return ShellImpl.this.readLine();
                    }
                };
                this.executorThread = thread = new ReturnValueThread(call);
                thread.run();
                thread.join();
                if (this.interruptedState) {
                    throw new AbortedException();
                }
                this.flush();
                if (thread.getException() instanceof EndOfStreamException) {
                    throw (EndOfStreamException)thread.getException();
                }
                String string = (String)thread.getValue();
                return string;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("[killed]");
            }
            finally {
                if (tempCompleter != null) {
                    this.reader.removeCompleter(tempCompleter);
                }
                this.reader.addCompleter(this.completer);
                this.reader.setHistoryEnabled(true);
                this.reader.setPrompt("");
                this.interruptedState = false;
            }
        }
    }

    public String promptSecret(String message) {
        if (!message.isEmpty() && message.matches("^.*\\S$")) {
            message = message + " ";
        }
        message = this.renderColor(ShellColor.CYAN, " ? ") + message;
        try {
            this.reader.removeCompleter(this.completer);
            this.reader.setHistoryEnabled(false);
            this.reader.setPrompt(message);
            this.flush();
            String line = this.readLine(Character.valueOf('*'));
            this.flush();
            String string = line;
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Shell input stream failure", e);
        }
        finally {
            this.reader.addCompleter(this.completer);
            this.reader.setHistoryEnabled(true);
            this.reader.setPrompt("");
        }
    }

    public <T> Set<T> promptMultiSelectWithWildcard(String wildcard, String message, Map<String, T> options) {
        String choice;
        if (options == null || options.isEmpty()) {
            throw new IllegalArgumentException("promptMultiSelect() Cannot ask user to select from a list of nothing. Ensure you have values in your options list.");
        }
        if (options.containsKey("")) {
            throw new IllegalArgumentException("empty labels not allowed");
        }
        if (options.containsKey(wildcard)) {
            throw new IllegalArgumentException("wildcard label duplicated among option labels");
        }
        if (wildcard != null && wildcard.trim().isEmpty()) {
            throw new IllegalArgumentException("blank/empty wildcard labels not allowed");
        }
        LinkedHashMap<String, String> fullOptions = new LinkedHashMap<String, String>();
        for (String key : options.keySet()) {
            fullOptions.put(key, key);
        }
        if (wildcard != null) {
            fullOptions.put(wildcard, wildcard);
        }
        fullOptions.put("", null);
        this.println(message);
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        StringBuilder prompt = new StringBuilder("select (");
        if (wildcard != null) {
            prompt.append('\"').append(wildcard).append('\"').append(" = all values; ");
        }
        prompt.append("empty = done)");
        while ((choice = (String)this.promptChoice(prompt.toString(), fullOptions)) != null) {
            if (choice.equals(wildcard)) {
                result.addAll(options.values());
                break;
            }
            result.add(options.get(choice));
            fullOptions.remove(choice);
            if (result.size() != options.size()) continue;
            break;
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    protected PromptTypeConverter getPromptTypeConverter() {
        return this.promptTypeConverter;
    }

    @Override
    protected ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public void setAnsiSupported(boolean value) {
        if (value != this.isAnsiSupported()) {
            try {
                if (value) {
                    this.configureOSTerminal();
                } else {
                    TerminalFactory.configure(TerminalFactory.Type.NONE);
                    TerminalFactory.reset();
                }
                this.initReaderAndStreams();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to reset Terminal instance for ANSI configuration", e);
            }
        }
    }

    public void bufferingMode() {
        this.screenBuffer.bufferOnlyMode();
    }

    public void directWriteMode() {
        this.screenBuffer.directWriteMode();
    }

    public void flush() {
        this.screenBuffer.flushBuffer();
    }

    public void registerBufferManager(BufferManager manager) {
        this.screenBuffer = manager;
    }

    public BufferManager getBufferManager() {
        return this.screenBuffer;
    }

    public void registerKeyListener(KeyListener keyListener) {
        this.reader.registerKeyListener(keyListener);
    }

    private void configureOSTerminal() throws IOException {
        if (OSUtils.isLinux() || OSUtils.isOSX()) {
            TerminalFactory.configure(TerminalFactory.Type.UNIX);
            TerminalFactory.reset();
        } else if (OSUtils.isWindows()) {
            TerminalFactory.configure(TerminalFactory.Type.WINDOWS);
            TerminalFactory.reset();
        } else {
            TerminalFactory.configure(TerminalFactory.Type.NONE);
            TerminalFactory.reset();
        }
        this.initReaderAndStreams();
    }

    public boolean isAnsiSupported() {
        return this.reader != null && this.reader.getTerminal().isAnsiSupported();
    }

    public ForgeEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    BeanManager getBeanManager() {
        return this.manager;
    }

    public ConsoleReader getReader() {
        return this.reader;
    }

    private class ReturnValueThread<V>
    extends Thread {
        private V value;
        private final Callable<V> caller;
        private Throwable exception;

        private ReturnValueThread(Callable<V> caller) {
            this.caller = caller;
        }

        @Override
        public void run() {
            try {
                this.value = this.caller.call();
            }
            catch (Exception e) {
                try {
                    this.exception = e;
                    ShellImpl.this.handleException(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public V getValue() {
            return this.value;
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    private class ExecutorThread
    extends Thread {
        private final String run;

        private ExecutorThread(String run) {
            this.run = run;
        }

        @Override
        public void run() {
            ShellImpl.this.fshRuntime.run(this.run);
        }
    }

    private static enum BufferingMode {
        Direct,
        Buffering;

    }
}

