/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.buffers;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.fusesource.jansi.internal.WindowsSupport;
import org.jboss.forge.shell.util.OSUtils;

public class ConsoleInputSession {
    private InputStream consoleStream;
    private InputStream externalInputStream;
    private static final ArrayBlockingQueue<Integer> blockingQueue = new ArrayBlockingQueue(1000);
    private boolean isEmbedded;
    private volatile boolean connected;

    public ConsoleInputSession(InputStream consoleStream, boolean isEmbedded) {
        this.consoleStream = consoleStream;
        this.connected = true;
        this.isEmbedded = isEmbedded;
        this.externalInputStream = new InputStream(){
            private Integer b;

            @Override
            public int read() throws IOException {
                try {
                    this.b = (Integer)blockingQueue.poll(365L, TimeUnit.DAYS);
                    if (this.b != null) {
                        return this.b;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return -1;
            }
        };
        this.startReader();
    }

    private void startReader() {
        Thread readerThread = null;
        readerThread = OSUtils.isWindows() && !this.isEmbedded ? new WindowsReaderThread() : new GenericReaderThread();
        readerThread.setDaemon(true);
        readerThread.start();
    }

    public void interruptPipe() {
        for (byte b : OSUtils.getLineSeparator().getBytes()) {
            blockingQueue.offer(Integer.valueOf(b));
        }
    }

    public void stop() {
        this.connected = false;
    }

    public InputStream getExternalInputStream() {
        return this.externalInputStream;
    }

    private final class WindowsReaderThread
    extends Thread {
        private WindowsReaderThread() {
        }

        @Override
        public void run() {
            while (ConsoleInputSession.this.connected) {
                try {
                    int read = WindowsSupport.readByte();
                    blockingQueue.put(read);
                    Thread.yield();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    private final class GenericReaderThread
    extends Thread {
        private GenericReaderThread() {
        }

        @Override
        public void run() {
            while (ConsoleInputSession.this.connected) {
                try {
                    int read = ConsoleInputSession.this.consoleStream.read();
                    blockingQueue.put(read);
                    Thread.yield();
                }
                catch (IOException e) {
                    if (!ConsoleInputSession.this.connected) continue;
                    ConsoleInputSession.this.connected = false;
                    throw new RuntimeException("broken pipe");
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

