/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessManagedBean;
import org.jboss.forge.bus.util.Annotations;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.Project;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.CommandMetadataImpl;
import org.jboss.forge.shell.command.OptionMetadataImpl;
import org.jboss.forge.shell.command.PluginMetadata;
import org.jboss.forge.shell.command.PluginMetadataImpl;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeIn;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.shell.plugins.SetupCommand;
import org.jboss.forge.shell.plugins.Topic;

public class CommandLibraryExtension
implements Extension {
    private final Map<String, List<PluginMetadata>> plugins = new HashMap<String, List<PluginMetadata>>();
    private Set<Class<? extends Facet>> facetTypes = new HashSet<Class<? extends Facet>>();

    public Map<String, List<PluginMetadata>> getPlugins() {
        return this.plugins;
    }

    public void scan(@Observes ProcessManagedBean<?> event) throws Exception {
        Bean bean = event.getBean();
        Class clazz = bean.getBeanClass();
        if (Plugin.class.isAssignableFrom(clazz)) {
            PluginMetadata pluginMeta = this.getMetadataFor(clazz);
            if (!this.plugins.containsKey(pluginMeta.getName())) {
                this.plugins.put(pluginMeta.getName(), new ArrayList());
            }
            this.plugins.get(pluginMeta.getName()).add(pluginMeta);
        }
        if (Facet.class.isAssignableFrom(clazz) && !clazz.isInterface() && !clazz.isAnnotation()) {
            this.facetTypes.add(clazz);
        }
    }

    public <T extends Facet> void validateFacet(@Observes ProcessInjectionTarget<T> injectionTarget) {
        Class facetClass = injectionTarget.getAnnotatedType().getJavaClass();
        Set injectionPoints = injectionTarget.getInjectionTarget().getInjectionPoints();
        for (InjectionPoint injectionPoint : injectionPoints) {
            Type baseType = injectionPoint.getAnnotated().getBaseType();
            if (!(baseType instanceof Class) || !Project.class.isAssignableFrom((Class)baseType)) continue;
            throw new IllegalStateException("Facet " + facetClass.getName() + " must not @Inject Project. Please remove it and use getProject() instead.");
        }
    }

    public Set<Class<? extends Facet>> getFacetTypes() {
        return Collections.unmodifiableSet(this.facetTypes);
    }

    public PluginMetadata getMetadataFor(Class<? extends Plugin> plugin) {
        String name = this.getPluginName(plugin);
        PluginMetadataImpl pluginMeta = new PluginMetadataImpl();
        pluginMeta.setName(name);
        pluginMeta.setType(plugin);
        if (Annotations.isAnnotationPresent(plugin, Help.class)) {
            pluginMeta.setHelp(((Help)Annotations.getAnnotation(plugin, Help.class)).value());
        } else {
            pluginMeta.setHelp("");
        }
        if (Annotations.isAnnotationPresent(plugin, RequiresResource.class)) {
            List<Class<? extends Resource<?>>> resourceTypes = Arrays.asList(((RequiresResource)Annotations.getAnnotation(plugin, RequiresResource.class)).value());
            pluginMeta.setResourceScopes(resourceTypes);
        }
        if (Annotations.isAnnotationPresent(plugin, Topic.class)) {
            pluginMeta.setTopic(((Topic)Annotations.getAnnotation(plugin, Topic.class)).value());
        }
        this.processPluginCommands(pluginMeta, plugin);
        return pluginMeta;
    }

    private List<CommandMetadata> processPluginCommands(PluginMetadataImpl pluginMeta, Class<?> plugin) {
        ArrayList<CommandMetadata> results = new ArrayList<CommandMetadata>();
        for (Method method : plugin.getMethods()) {
            DefaultCommand def;
            if (!Annotations.isAnnotationPresent((Method)method, Command.class)) continue;
            Command command = (Command)Annotations.getAnnotation((Method)method, Command.class);
            CommandMetadataImpl commandMeta = new CommandMetadataImpl();
            commandMeta.setMethod(method);
            commandMeta.setHelp(command.help());
            commandMeta.setParent(pluginMeta);
            if ("".equals(command.value())) {
                commandMeta.setName(method.getName().trim().toLowerCase());
            } else {
                commandMeta.setName(command.value());
            }
            if (Annotations.isAnnotationPresent((Method)method, DefaultCommand.class)) {
                if (pluginMeta.hasDefaultCommand()) {
                    throw new IllegalStateException("Plugins may only have one @" + DefaultCommand.class.getSimpleName() + ", but [" + pluginMeta.getType() + "] has more than one.");
                }
                commandMeta.setDefault(true);
                commandMeta.setName(pluginMeta.getName());
                def = (DefaultCommand)Annotations.getAnnotation((Method)method, DefaultCommand.class);
                if (def.help() != null && !def.help().trim().isEmpty()) {
                    commandMeta.setHelp(def.help());
                }
            }
            if (Annotations.isAnnotationPresent((Method)method, SetupCommand.class)) {
                if (pluginMeta.hasSetupCommand()) {
                    throw new IllegalStateException("Plugins may only have one @" + SetupCommand.class.getSimpleName() + ", but [" + pluginMeta.getType() + "] has more than one.");
                }
                commandMeta.setSetup(true);
                commandMeta.setName("setup");
                def = (SetupCommand)Annotations.getAnnotation((Method)method, SetupCommand.class);
                if (def.help() != null && !def.help().trim().isEmpty()) {
                    commandMeta.setHelp(def.help());
                }
            } else if (Annotations.isAnnotationPresent((Method)method, RequiresResource.class)) {
                ArrayList<Class<? extends Resource>> resourceTypes = new ArrayList<Class<? extends Resource>>(pluginMeta.getResourceScopes());
                resourceTypes.addAll(Arrays.asList(((RequiresResource)Annotations.getAnnotation((Method)method, RequiresResource.class)).value()));
                commandMeta.setResourceScopes(resourceTypes);
            }
            if (commandMeta.getHelp() == null || commandMeta.getHelp().trim().isEmpty()) {
                commandMeta.setHelp(pluginMeta.getHelp());
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            int i = 0;
            for (Class<?> clazz : parameterTypes) {
                OptionMetadataImpl optionMeta = new OptionMetadataImpl();
                optionMeta.setType(clazz);
                optionMeta.setIndex(i);
                if (PipeOut.class.isAssignableFrom(clazz)) {
                    optionMeta.setPipeOut(true);
                }
                for (Annotation annotation : parameterAnnotations[i]) {
                    if (annotation instanceof Option) {
                        Option option = (Option)annotation;
                        optionMeta.setParent(commandMeta);
                        optionMeta.setName(option.name());
                        optionMeta.setShortName(option.shortName());
                        optionMeta.setFlagOnly(option.flagOnly());
                        optionMeta.setDescription(option.description());
                        optionMeta.setDefaultValue(option.defaultValue());
                        optionMeta.setHelp(option.help());
                        optionMeta.setRequired(option.required());
                        optionMeta.setPromptType(option.type());
                        optionMeta.setCompleterType(option.completer());
                        continue;
                    }
                    if (!(annotation instanceof PipeIn)) continue;
                    optionMeta.setPipeIn(true);
                }
                commandMeta.addOption(optionMeta);
                ++i;
            }
            results.add(commandMeta);
        }
        pluginMeta.addCommands(results);
        return results;
    }

    private String getPluginName(Class<?> plugin) {
        Alias named;
        String name = null;
        if (Annotations.isAnnotationPresent(plugin, Alias.class) && (named = (Alias)Annotations.getAnnotation(plugin, Alias.class)) != null) {
            name = named.value();
        }
        if (name == null || "".equals(name.trim())) {
            name = plugin.getSimpleName();
        }
        return name.toLowerCase();
    }
}

