/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command;

import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.OptionMetadata;
import org.jboss.forge.shell.completer.CommandCompleter;
import org.jboss.forge.shell.completer.NullCommandCompleter;
import org.jboss.forge.shell.util.Types;
import org.mvel2.util.ParseTools;
import org.mvel2.util.StringAppender;

public class OptionMetadataImpl
implements OptionMetadata {
    private CommandMetadata parent;
    private Class<?> type;
    private int index;
    private String name = "";
    private String shortName = "";
    private String defaultValue = "";
    private String description = "";
    private String help = "";
    private boolean flagOnly = false;
    private boolean required = false;
    private PromptType promptType;
    private boolean pipeOut;
    private boolean pipeIn;
    private Class<? extends CommandCompleter> completerType;

    public String getOptionDescriptor() {
        StringAppender appender = new StringAppender("[");
        if (this.isNamed()) {
            appender.append(this.name).append("=");
        }
        if (this.getDescription().equals("")) {
            appender.append("ARG");
        } else {
            appender.append(this.description);
        }
        appender.append(" (of type ").append(Types.getTypeDescriptor(this.type)).append(")");
        return appender.append(']').toString();
    }

    public boolean isNamed() {
        return this.name != null && !"".equals(this.name);
    }

    public Class<?> getBoxedType() {
        return ParseTools.boxPrimitive(this.getType());
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public boolean isFlagOnly() {
        return this.flagOnly;
    }

    public void setFlagOnly(boolean flagOnly) {
        this.flagOnly = flagOnly;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String toString() {
        return this.name + ":" + this.description;
    }

    public CommandMetadata getParent() {
        return this.parent;
    }

    public void setParent(CommandMetadata parent) {
        this.parent = parent;
    }

    public boolean isBoolean() {
        return Boolean.TYPE.equals(this.getType()) || Boolean.class.equals(this.getType());
    }

    public boolean isEnum() {
        return this.getType() != null && this.getType().isEnum();
    }

    public boolean isVarargs() {
        return this.getType().isArray();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null && !"".equals(this.defaultValue);
    }

    public PromptType getPromptType() {
        return this.promptType;
    }

    public void setPromptType(PromptType type) {
        this.promptType = type;
    }

    public boolean isPipeOut() {
        return this.pipeOut;
    }

    public void setPipeOut(boolean pipeOut) {
        this.pipeOut = pipeOut;
    }

    public boolean isPipeIn() {
        return this.pipeIn;
    }

    public void setPipeIn(boolean pipeIn) {
        this.pipeIn = pipeIn;
    }

    public boolean notOrdered() {
        return this.pipeIn || this.pipeOut || this.isNamed();
    }

    public boolean isOrdered() {
        return !this.notOrdered();
    }

    public boolean hasCustomCompleter() {
        return this.completerType != null && !this.completerType.equals(NullCommandCompleter.class);
    }

    public void setCompleterType(Class<? extends CommandCompleter> type) {
        this.completerType = type;
    }

    public Class<? extends CommandCompleter> getCompleterType() {
        return this.completerType;
    }
}

