/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.parser.CommandParser;
import org.jboss.forge.shell.command.parser.CommandParserContext;

public class CompositeCommandParser
implements CommandParser {
    List<CommandParser> parsers = new ArrayList<CommandParser>();

    public CompositeCommandParser(CommandParser ... parsers) {
        this.parsers = Arrays.asList(parsers);
    }

    @Override
    public CommandParserContext parse(CommandMetadata command, Queue<String> tokens, CommandParserContext ctx) {
        boolean complete = false;
        CommandParserContext context = ctx;
        while (!complete) {
            boolean altered = false;
            for (CommandParser parser : this.parsers) {
                if (tokens.size() == 0) {
                    complete = true;
                    break;
                }
                int size = tokens.size();
                context = parser.parse(command, tokens, context);
                if (size <= tokens.size()) continue;
                altered = true;
                break;
            }
            if (altered) continue;
            break;
        }
        return ctx;
    }
}

