/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.observers;

import java.util.TreeSet;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.command.PluginRegistry;
import org.jboss.forge.shell.events.CommandMissing;
import org.jboss.forge.shell.exceptions.NoSuchCommandException;
import org.jboss.forge.shell.plugins.builtin.AliasRegistry;

public class DidYouMeanObserver {
    private static final int LETTERS_NEEDED_TO_BE_REPLACED = 2;
    @Inject
    private PluginRegistry pluginRegistry;
    @Inject
    private AliasRegistry aliasRegistry;

    public void suggestMissingPlugin(@Observes CommandMissing commandMissing, Shell shell) {
        String pluginName = commandMissing.getOriginalStatement().split(" ")[0];
        TreeSet<String> similarPlugins = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String plugin : this.pluginRegistry.getPlugins().keySet()) {
            if (Strings.getLevenshteinDistance((CharSequence)pluginName, (CharSequence)plugin) >= 2) continue;
            similarPlugins.add(plugin);
        }
        for (String alias : this.aliasRegistry.getAliases().keySet()) {
            if (Strings.getLevenshteinDistance((CharSequence)pluginName, (CharSequence)alias) >= 2) continue;
            similarPlugins.add(alias);
        }
        if (similarPlugins.isEmpty()) {
            throw new NoSuchCommandException(null, "No such command: " + commandMissing.getOriginalStatement());
        }
        ShellMessages.error((ShellPrintWriter)shell, (String)("No such command: " + pluginName));
        if (similarPlugins.size() == 1) {
            shell.println("Did you mean this ?");
        } else {
            shell.println("Did you mean any of these ?");
        }
        for (String plugin : similarPlugins) {
            shell.println(ShellColor.BOLD, "\t" + plugin);
        }
    }
}

