/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.command.PluginRegistry;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.plugins.builtin.SetupPluginCompleter;

@Alias(value="setup")
@Topic(value="Project")
@RequiresProject
@Help(value="Setup a plugin.")
@Singleton
public class SetupPlugin
implements Plugin {
    @Inject
    private Shell shell;
    @Inject
    private SetupPluginCompleter completer;
    @Inject
    private PluginRegistry registry;
    @Inject
    @Current
    private Resource<?> resource;

    @DefaultCommand
    public void run(@Option(description="The plugins to set up", required=true, completer=SetupPluginCompleter.class) String[] plugins, PipeOut out) throws Exception {
        for (String plugin : plugins) {
            if (!this.completer.getCompletionTokens().contains(plugin)) {
                if (this.registry.getPluginMetadataForScopeAndConstraints(plugin, this.shell) != null) {
                    throw new RuntimeException("Plugin does not have a [setup] method.");
                }
                throw new RuntimeException("No such plugin [" + plugin + "], or plugin not available for current Resource [" + this.resource.getClass().getName() + "]");
            }
            this.shell.execute(plugin + " setup");
        }
    }
}

