/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin.project;

import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.build.BuildException;
import org.jboss.forge.project.build.ProjectBuilder;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.plugins.builtin.project.ProfileCompleter;

@Alias(value="build")
@Topic(value="Project")
@RequiresProject
@RequiresFacet(value={DependencyFacet.class, PackagingFacet.class})
@Help(value="Perform a build using the underlying build system.")
public class BuildPlugin
implements Plugin {
    private Project project;

    public BuildPlugin() {
    }

    @Inject
    public BuildPlugin(Project project) {
        this.project = project;
    }

    @DefaultCommand
    public void build(PipeOut out, @Option(name="notest", flagOnly=true) boolean notest, @Option(name="profile", completer=ProfileCompleter.class) String profile, String ... args) {
        PackagingFacet packaging = (PackagingFacet)this.project.getFacet(PackagingFacet.class);
        ProjectBuilder builder = packaging.createBuilder();
        if (args == null) {
            builder.addArguments(new String[]{"install"});
        } else {
            builder.addArguments(args);
        }
        if (notest) {
            builder.runTests(false);
        }
        if (profile != null) {
            builder.addArguments(new String[]{"-P" + profile});
        }
        try {
            builder.build();
        }
        catch (BuildException e) {
            throw new RuntimeException("Build failed.", e);
        }
    }
}

