/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin.project;

import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.plugins.builtin.project.ProfileCompleter;

@Alias(value="test")
@Topic(value="Project")
@RequiresProject
@RequiresFacet(value={DependencyFacet.class, PackagingFacet.class})
@Help(value="Execute this project's test suite using the underlying build system.")
public class TestPlugin
implements Plugin {
    private Project project;

    public TestPlugin() {
    }

    @Inject
    public TestPlugin(Project project) {
        this.project = project;
    }

    @DefaultCommand
    public void build(PipeOut out, @Option(name="profile", completer=ProfileCompleter.class) String profile, String ... args) {
        PackagingFacet packaging = (PackagingFacet)this.project.getFacet(PackagingFacet.class);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("test");
        if (args != null) {
            arguments.addAll(Arrays.asList(args));
        }
        if (profile != null) {
            arguments.add("-P" + profile);
        }
        packaging.executeBuild(arguments.toArray(new String[0]));
    }
}

