/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.OptionMetadata;
import org.jboss.forge.shell.command.PluginMetadata;

public class CommandMetadataImpl
implements CommandMetadata {
    private PluginMetadata parent;
    private Method method;
    private boolean isDefault = false;
    private boolean isSetup = false;
    private String name = "";
    private String help = "";
    private List<OptionMetadata> options = new ArrayList<OptionMetadata>();
    private Set<Class<? extends Resource>> resourceScopes = Collections.emptySet();

    public OptionMetadata getNamedOption(String name) throws IllegalArgumentException {
        for (OptionMetadata option : this.options) {
            if (!option.isNamed() || !option.getName().equals(name) && !option.getShortName().equals(name)) continue;
            return option;
        }
        throw new IllegalArgumentException("No such option [" + name + "] for command: " + this);
    }

    public OptionMetadata getOptionByAbsoluteIndex(int index) {
        for (OptionMetadata option : this.options) {
            if (option.getIndex() != index) continue;
            return option;
        }
        throw new IllegalArgumentException("No option with index [" + index + "] exists for command: " + this);
    }

    public OptionMetadata getOrderedOptionByIndex(int index) throws IllegalArgumentException {
        int currentIndex = 0;
        for (OptionMetadata option : this.options) {
            if (option.isOrdered() && index == currentIndex) {
                return option;
            }
            if (!option.isOrdered()) continue;
            ++currentIndex;
        }
        throw new IllegalArgumentException("No option with index [" + index + "] exists for command: " + this);
    }

    public int getNumOrderedOptions() {
        int count = 0;
        for (OptionMetadata option : this.options) {
            if (!option.isOrdered()) continue;
            ++count;
        }
        return count;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public boolean isSetup() {
        return this.isSetup;
    }

    public void setSetup(boolean isSetup) {
        this.isSetup = isSetup;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<OptionMetadata> getOptions() {
        if (this.options == null) {
            this.options = new ArrayList<OptionMetadata>();
        }
        Collections.sort(this.options, new Comparator<OptionMetadata>(){

            @Override
            public int compare(OptionMetadata l, OptionMetadata r) {
                if (l == r) {
                    return 0;
                }
                if (l != r && l == null) {
                    return 1;
                }
                if (l != r && r == null) {
                    return -1;
                }
                if (l.getIndex() == r.getIndex()) {
                    return 0;
                }
                if (l.getIndex() > r.getIndex()) {
                    return 1;
                }
                if (l.getIndex() < r.getIndex()) {
                    return -1;
                }
                return 0;
            }
        });
        return this.options;
    }

    public void addOption(OptionMetadata option) {
        this.options.add(option);
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String toString() {
        return this.name;
    }

    public PluginMetadata getParent() {
        return this.parent;
    }

    public void setParent(PluginMetadata parent) {
        this.parent = parent;
    }

    public boolean hasOptions() {
        return !this.getOptions().isEmpty();
    }

    public boolean hasShortOption(String name) {
        for (OptionMetadata option : this.options) {
            if (!option.isNamed() || !option.getShortName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOption(String name) {
        for (OptionMetadata option : this.options) {
            if (!option.isNamed() || !option.getName().equals(name) && (!option.getShortName().equals(name) || option.getShortName().isEmpty())) continue;
            return true;
        }
        return false;
    }

    public Set<Class<? extends Resource>> getResourceScopes() {
        return this.resourceScopes;
    }

    public void setResourceScopes(List<Class<? extends Resource>> resourceScopes) {
        this.resourceScopes = new HashSet<Class<? extends Resource>>(resourceScopes);
    }

    public boolean usableWithResource(Class<? extends Resource> resource) {
        return this.resourceScopes.size() == 0 || this.resourceScopes.contains(resource);
    }

    public boolean hasOrderedOptions() {
        try {
            this.getOrderedOptionByIndex(0);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

