/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.inject.Singleton;
import org.jboss.forge.shell.command.CommandScoped;
import org.jboss.forge.shell.events.CommandExecuted;
import org.jboss.forge.shell.events.CommandVetoed;
import org.jboss.forge.shell.events.PreCommandExecution;

@Singleton
public class CommandScopedContext
implements Context {
    private static final String COMPONENT_MAP_NAME = CommandScopedContext.class.getName() + ".componentInstanceMap";
    private static final String CREATIONAL_MAP_NAME = CommandScopedContext.class.getName() + ".creationalInstanceMap";
    private static final Stack<Map<Object, Object>> contextStack = new Stack();

    private void assertActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("Context with scope annotation @CommandScoped is not active since no command is in execution.");
        }
    }

    public Map<Object, Object> getCurrentContext() {
        return contextStack.peek();
    }

    public void create(@Observes PreCommandExecution execution) {
        contextStack.push(execution.getContext());
    }

    public void destroy(@Observes CommandExecuted event) {
        this.destroyCurrentContext();
        contextStack.pop();
    }

    public void destroy(@Observes CommandVetoed event) {
        this.destroyCurrentContext();
        contextStack.pop();
    }

    private void destroyCurrentContext() {
        Map<Contextual<?>, Object> componentInstanceMap = this.getComponentInstanceMap();
        Map<Contextual<?>, CreationalContext<?>> creationalContextMap = this.getCreationalContextMap();
        if (componentInstanceMap != null && creationalContextMap != null) {
            for (Map.Entry<Contextual<?>, Object> componentEntry : componentInstanceMap.entrySet()) {
                Contextual<?> contextual = componentEntry.getKey();
                Object instance = componentEntry.getValue();
                CreationalContext<?> creational = creationalContextMap.get(contextual);
                contextual.destroy(instance, creational);
            }
        }
        this.getCurrentContext().clear();
    }

    public boolean isActive() {
        return !contextStack.isEmpty();
    }

    public Class<? extends Annotation> getScope() {
        return CommandScoped.class;
    }

    public <T> T get(Contextual<T> component) {
        this.assertActive();
        return (T)this.getComponentInstanceMap().get(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        this.assertActive();
        Object instance = this.get(component);
        if (instance == null) {
            Map<Contextual<?>, Object> componentInstanceMap;
            Map<Contextual<?>, CreationalContext<?>> creationalContextMap = this.getCreationalContextMap();
            Map<Contextual<?>, Object> map = componentInstanceMap = this.getComponentInstanceMap();
            synchronized (map) {
                instance = componentInstanceMap.get(component);
                if (instance == null && (instance = component.create(creationalContext)) != null) {
                    componentInstanceMap.put(component, instance);
                    creationalContextMap.put(component, creationalContext);
                }
            }
        }
        return instance;
    }

    private Map<Contextual<?>, Object> getComponentInstanceMap() {
        ConcurrentHashMap map = (ConcurrentHashMap)this.getCurrentContext().get(COMPONENT_MAP_NAME);
        if (map == null) {
            map = new ConcurrentHashMap();
            this.getCurrentContext().put(COMPONENT_MAP_NAME, map);
        }
        return map;
    }

    private Map<Contextual<?>, CreationalContext<?>> getCreationalContextMap() {
        ConcurrentHashMap map = (ConcurrentHashMap)this.getCurrentContext().get(CREATIONAL_MAP_NAME);
        if (map == null) {
            map = new ConcurrentHashMap();
            this.getCurrentContext().put(CREATIONAL_MAP_NAME, map);
        }
        return map;
    }
}

