/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.completer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.OptionMetadata;
import org.jboss.forge.shell.completer.CompletedCommandHolder;
import org.jboss.forge.shell.completer.PluginCommandCompleterState;
import org.jboss.forge.shell.console.jline.console.ConsoleReader;
import org.jboss.forge.shell.console.jline.console.CursorBuffer;
import org.jboss.forge.shell.console.jline.console.completer.CandidateListCompletionHandler;
import org.jboss.forge.shell.console.jline.console.completer.CompletionHandler;

public class OptionAwareCompletionHandler
implements CompletionHandler {
    private final CompletedCommandHolder commandHolder;
    private final Shell shell;

    public OptionAwareCompletionHandler(CompletedCommandHolder commandHolder, Shell shell) {
        this.commandHolder = commandHolder;
        this.shell = shell;
    }

    @Override
    public boolean complete(ConsoleReader reader, List<CharSequence> candidates, int pos) throws IOException {
        String value;
        CursorBuffer buf = reader.getCursorBuffer();
        PluginCommandCompleterState state = this.commandHolder.getState();
        if (state != null && (candidates.size() == 1 && "".equals(candidates.get(0)) || state.isDuplicateBuffer() && state.isFinalTokenComplete()) && this.commandHolder.getState().getOption() != null) {
            OptionMetadata option = this.commandHolder.getState().getOption();
            reader.println();
            reader.println(option.getOptionDescriptor());
            if (candidates.size() == 1) {
                reader.println();
                reader.drawLine();
                return true;
            }
        }
        if (candidates.size() == 1) {
            value = ((Object)candidates.get(0)).toString();
            if (!Strings.isNullOrEmpty((String)value)) {
                value = value.substring(0, value.length() - 1).replace(" ", "\\ ") + value.substring(value.length() - 1);
            }
            if (value.equals(buf.toString())) {
                return false;
            }
            OptionAwareCompletionHandler.setBuffer(reader, value, pos);
            return true;
        }
        if (candidates.size() > 1) {
            value = this.getUnambiguousCompletions(candidates).replace(" ", "\\ ");
            OptionAwareCompletionHandler.setBuffer(reader, value, pos);
        }
        this.printCandidates(reader, candidates);
        reader.drawLine();
        reader.flush();
        return true;
    }

    public static void setBuffer(ConsoleReader reader, CharSequence value, int offset) throws IOException {
        while (reader.getCursorBuffer().cursor > offset && reader.backspace()) {
        }
        reader.putString(value);
        reader.setCursorPosition(offset + value.length());
    }

    public void printCandidates(ConsoleReader reader, Collection<CharSequence> candidates) throws IOException {
        HashSet<CharSequence> distinct = new HashSet<CharSequence>(candidates);
        if (distinct.size() > reader.getAutoprintThreshold()) {
            int c;
            reader.print(Messages.DISPLAY_CANDIDATES.format(candidates.size()));
            reader.flush();
            String noOpt = Messages.DISPLAY_CANDIDATES_NO.format(new Object[0]);
            String yesOpt = Messages.DISPLAY_CANDIDATES_YES.format(new Object[0]);
            char[] allowed = new char[]{yesOpt.charAt(0), noOpt.charAt(0)};
            while ((c = reader.readCharacter(allowed)) != -1) {
                String tmp = new String(new char[]{(char)c});
                if (noOpt.startsWith(tmp)) {
                    reader.println();
                    reader.flush();
                    return;
                }
                if (yesOpt.startsWith(tmp)) break;
                reader.beep();
                reader.flush();
            }
        }
        if (distinct.size() != candidates.size()) {
            ArrayList<CharSequence> copy = new ArrayList<CharSequence>();
            for (CharSequence next : candidates) {
                if (copy.contains(next)) continue;
                copy.add(next);
            }
            candidates = copy;
        }
        reader.println();
        reader.flush();
        ArrayList<CharSequence> colorizedCandidates = new ArrayList<CharSequence>();
        for (CharSequence seq : candidates) {
            CommandMetadata command;
            boolean processed = false;
            if (this.commandHolder.getState() != null && (command = this.commandHolder.getState().getCommand()) != null && ((Object)seq).toString().startsWith("--")) {
                String str = ((Object)seq).toString().trim();
                if (str.startsWith("--")) {
                    str = str.substring(2);
                }
                if (command.hasOption(str) && command.getNamedOption(str).isRequired()) {
                    seq = this.shell.renderColor(ShellColor.BLUE, ((Object)seq).toString());
                    colorizedCandidates.add(seq);
                    processed = true;
                }
            }
            if (processed) continue;
            colorizedCandidates.add(seq);
        }
        reader.printColumns(colorizedCandidates);
        reader.flush();
    }

    private String getUnambiguousCompletions(List<CharSequence> candidates) {
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        String[] strings = candidates.toArray(new String[candidates.size()]);
        String first = strings[0];
        StringBuilder candidate = new StringBuilder();
        for (int i = 0; i < first.length() && this.startsWith(first.substring(0, i + 1), strings); ++i) {
            candidate.append(first.charAt(i));
        }
        return candidate.toString();
    }

    private boolean startsWith(String starts, String[] candidates) {
        for (String candidate : candidates) {
            if (candidate.startsWith(starts)) continue;
            return false;
        }
        return true;
    }

    private static enum Messages {
        DISPLAY_CANDIDATES,
        DISPLAY_CANDIDATES_YES,
        DISPLAY_CANDIDATES_NO;


        public String format(Object ... args) {
            ResourceBundle bundle = ResourceBundle.getBundle(CandidateListCompletionHandler.class.getName());
            return String.format(bundle.getString(this.name()), args);
        }
    }
}

