/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.completer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.inject.Inject;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.command.PluginMetadata;
import org.jboss.forge.shell.command.PluginRegistry;
import org.jboss.forge.shell.completer.CommandCompleter;
import org.jboss.forge.shell.completer.CommandCompleterState;
import org.jboss.forge.shell.completer.PluginCommandCompleter;
import org.jboss.forge.shell.completer.PluginCommandCompleterState;

public class PluginResolverCompleter
implements CommandCompleter {
    @Inject
    private Shell shell;
    @Inject
    private PluginRegistry registry;

    public void complete(CommandCompleterState st) {
        PluginCommandCompleterState state = (PluginCommandCompleterState)st;
        Queue<String> tokens = state.getTokens();
        if (!tokens.isEmpty()) {
            String pluginName = tokens.remove();
            PluginMetadata plugin = this.registry.getPluginMetadataForScopeAndConstraints(pluginName, this.shell);
            if (plugin != null) {
                state.setPlugin(plugin);
                if (tokens.isEmpty()) {
                    if (state.isFinalTokenComplete()) {
                        state.setIndex(state.getBuffer().length());
                    } else {
                        state.getCandidates().add(pluginName + " ");
                        state.setIndex(0);
                    }
                }
            } else {
                state.setIndex(0);
                if (tokens.isEmpty()) {
                    List<String> pluginCandidates = this.getPluginCandidates(this.registry, pluginName);
                    state.getCandidates().addAll(pluginCandidates);
                }
            }
        } else {
            state.setIndex(0);
            List<String> pluginCandidates = this.getPluginCandidates(this.registry, "");
            state.getCandidates().addAll(pluginCandidates);
        }
    }

    private List<String> getPluginCandidates(PluginRegistry registry, String pluginBase) {
        Map plugins = registry.getPlugins();
        ArrayList<String> results = new ArrayList<String>();
        for (Map.Entry entry : plugins.entrySet()) {
            for (PluginMetadata pluginMeta : (List)entry.getValue()) {
                String pluginName;
                if (!pluginMeta.hasCommands() || !PluginCommandCompleter.isPotentialMatch(pluginName = pluginMeta.getName(), pluginBase) || !pluginMeta.constrantsSatisfied(this.shell) && !pluginMeta.isSetupAvailable(this.shell)) continue;
                results.add(pluginName + " ");
            }
        }
        return results;
    }
}

