/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.maven.model.Model;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.parser.ParserException;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParser;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyResolver;
import org.jboss.forge.project.dependencies.ScopeType;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.project.packaging.PackagingType;
import org.jboss.forge.project.services.ProjectFactory;
import org.jboss.forge.resources.DependencyResource;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.InstalledPluginRegistry;
import org.jboss.forge.shell.PluginEntry;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.events.PluginInstalled;
import org.jboss.forge.shell.events.PluginRemoved;
import org.jboss.forge.shell.exceptions.Abort;

public class PluginManager {
    private static final String MODULE_TEMPLATE_XML = "/org/jboss/forge/modules/module-template.xml";
    private static final Dependency SHELL_API = DependencyBuilder.create((String)"org.jboss.forge:forge-shell-api");
    @Inject
    private Event<PluginInstalled> pluginInstalledEvent;
    @Inject
    private Event<PluginRemoved> pluginRemovedEvent;
    @Inject
    private ForgeEnvironment environment;
    @Inject
    private Shell shell;
    @Inject
    private DependencyResolver resolver;
    @Inject
    private ProjectFactory projectFactory;

    public boolean removePlugin(String pluginName) {
        PluginEntry plugin = PluginEntry.fromCoordinates((String)pluginName);
        if (!InstalledPluginRegistry.has(plugin)) {
            throw new RuntimeException("No such installed plugin [" + pluginName + "]");
        }
        PluginEntry installedPlugin = InstalledPluginRegistry.get(plugin);
        InstalledPluginRegistry.remove(installedPlugin);
        this.pluginRemovedEvent.fire((Object)new PluginRemoved(installedPlugin));
        return !InstalledPluginRegistry.has(plugin);
    }

    public void installFromProject(DirectoryResource buildDir, Dependency coordinates) throws Abort {
        Resource artifact;
        Dependency managedDependency;
        DirectoryResource root = this.projectFactory.findProjectRootRecusively(buildDir);
        Project rootProject = this.projectFactory.findProject(root);
        if (rootProject == null) {
            throw new IllegalArgumentException("Unable to recognise plugin project in [" + buildDir.getFullyQualifiedName() + "]");
        }
        Project pluginProject = this.findPluginProject(rootProject, coordinates);
        if (pluginProject == null) {
            throw new Abort("The project does not contain a valid Forge Plugin project. Installation aborted");
        }
        DependencyFacet deps = (DependencyFacet)pluginProject.getFacet(DependencyFacet.class);
        String apiVersion = null;
        Dependency directDependency = deps.getDirectDependency(SHELL_API);
        if (directDependency != null && !Strings.isNullOrEmpty((String)directDependency.getVersion())) {
            apiVersion = directDependency.getVersion();
        }
        if (apiVersion == null && (managedDependency = deps.getManagedDependency(SHELL_API)) != null && !Strings.isNullOrEmpty((String)managedDependency.getVersion())) {
            apiVersion = managedDependency.getVersion();
        }
        if (apiVersion == null) {
            Dependency effectiveDependency = deps.getEffectiveDependency(SHELL_API);
            apiVersion = effectiveDependency != null ? effectiveDependency.getVersion() : this.environment.getRuntimeVersion();
        }
        List<String> groupIds = Arrays.asList("org.jboss.seam.render", "org.jboss.forge");
        List<String> providedDeps = Arrays.asList("forge-javaee-api", "forge-maven-api", "forge-scaffold-api", "forge-scaffoldx-api", "forge-shell-api");
        List dependencies = deps.getDependencies();
        for (Dependency dependency : dependencies) {
            Dependency effectiveDependency;
            if (groupIds.contains(dependency.getGroupId()) && !ScopeType.PROVIDED.equals((Object)dependency.getScopeTypeEnum()) && !ScopeType.TEST.equals((Object)dependency.getScopeTypeEnum())) {
                ShellMessages.warn((ShellPrintWriter)this.shell, (String)("Dependency [" + dependency.toCoordinates() + "] was not correctly marked as PROVIDED scope; this has been corrected."));
                deps.addDirectDependency((Dependency)DependencyBuilder.create((Dependency)dependency).setScopeType(ScopeType.PROVIDED));
                continue;
            }
            if (!"org.jboss.forge".equals(dependency.getGroupId()) || providedDeps.contains(dependency.getArtifactId()) || (effectiveDependency = deps.getEffectiveDependency(dependency)) == null || ScopeType.TEST == effectiveDependency.getScopeTypeEnum()) continue;
            ShellMessages.warn((ShellPrintWriter)this.shell, (String)("Plugin has a dependency on internal Forge API [" + dependency + "] - this is not allowed and may cause failures."));
        }
        ShellMessages.info((ShellPrintWriter)this.shell, (String)"Invoking build with underlying build system.");
        if (rootProject.equals(pluginProject)) {
            artifact = ((PackagingFacet)rootProject.getFacet(PackagingFacet.class)).createBuilder().runTests(false).build();
        } else {
            ((PackagingFacet)rootProject.getFacet(PackagingFacet.class)).createBuilder().addArguments(new String[]{"clean", "install"}).runTests(false).build();
            artifact = ((PackagingFacet)pluginProject.getFacet(PackagingFacet.class)).getFinalArtifact();
        }
        if (artifact == null || !artifact.exists()) {
            throw new IllegalStateException("Build artifact [" + artifact + "] is missing and cannot be installed. Please resolve build errors and try again.");
        }
        MetadataFacet meta = (MetadataFacet)rootProject.getFacet(MetadataFacet.class);
        Dependency dep = meta.getOutputDependency();
        ShellMessages.info((ShellPrintWriter)this.shell, (String)"Installing plugin artifact.");
        this.createModule(pluginProject, (Dependency)DependencyBuilder.create((Dependency)dep).setVersion(dep.getVersion() + "-" + UUID.randomUUID().toString()), artifact, apiVersion);
    }

    Project findPluginProject(Project rootProject, Dependency coordinates) {
        Object pluginProject;
        Model rootPom = ((MavenCoreFacet)rootProject.getFacet(MavenCoreFacet.class)).getPOM();
        DependencyBuilder projectDependency = DependencyBuilder.create().setGroupId(rootPom.getGroupId() == null ? rootPom.getParent().getGroupId() : rootPom.getGroupId()).setArtifactId(rootPom.getArtifactId()).setPackagingType(rootPom.getPackaging());
        if (projectDependency.getPackagingTypeEnum() == PackagingType.BASIC) {
            String module;
            DirectoryResource moduleDir;
            Project moduleProject;
            Project tempPluginProject = null;
            DirectoryResource projectDir = rootProject.getProjectRoot();
            Iterator i$ = rootPom.getModules().iterator();
            while (i$.hasNext() && ((moduleProject = this.projectFactory.findProject(moduleDir = projectDir.getChildDirectory(module = (String)i$.next()))).equals(rootProject) || (tempPluginProject = this.findPluginProject(moduleProject, coordinates)) == null)) {
            }
            pluginProject = tempPluginProject;
        } else {
            pluginProject = coordinates == null || DependencyBuilder.areEquivalent((Dependency)projectDependency, (Dependency)coordinates) ? rootProject : null;
        }
        return pluginProject;
    }

    private boolean needDependenciesAsResourceRoot(Project project) {
        FileResource forgeXml = (FileResource)project.getProjectRoot().getChild("src/main/resources/META-INF/forge.xml");
        if (forgeXml.exists()) {
            try {
                Node node = XMLParser.parse((InputStream)forgeXml.getResourceInputStream());
                return node.getSingle("dependencies-as-resource-root") != null;
            }
            catch (ParserException e) {
                return false;
            }
        }
        return false;
    }

    private DirectoryResource createModule(Project project, Dependency dep, Resource<?> artifact, String apiVersion) throws Abort {
        boolean dependenciesAsResourceRoot = this.needDependenciesAsResourceRoot(project);
        DirectoryResource moduleDir = this.getOrCreatePluginModuleDirectory(dep);
        String pluginName = dep.getGroupId() + "." + dep.getArtifactId();
        String pluginSlot = dep.getVersion();
        FileResource moduleXml = (FileResource)moduleDir.getChild("module.xml");
        if (moduleXml.exists() && !this.shell.promptBoolean("An existing installation for version [" + pluginSlot + "] of this plugin was found. Replace it?", true)) {
            throw new Abort("Aborted.");
        }
        moduleXml.delete();
        moduleXml.createNewFile();
        Node module = XMLParser.parse((InputStream)this.getClass().getResourceAsStream(MODULE_TEMPLATE_XML));
        module.attribute("name", pluginName);
        module.attribute("slot", pluginSlot);
        Node resources = module.getSingle("resources");
        resources.createChild("resource-root").attribute("path", dep.getArtifactId() + ".jar");
        if (dependenciesAsResourceRoot) {
            this.writeResourceRoots(project, module, moduleDir, resources);
        }
        FileResource jar = (FileResource)moduleDir.getChild(dep.getArtifactId() + ".jar").reify(FileResource.class);
        jar.createNewFile();
        jar.setContents(artifact.getResourceInputStream());
        Node dependencies = module.getSingle("dependencies");
        if (!dependenciesAsResourceRoot) {
            dependencies.createChild("module").attribute("name", pluginName + ".dependencies").attribute("slot", pluginSlot);
        }
        dependencies.createChild("module").attribute("name", "org.jboss.forge.javaee.api").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "org.jboss.forge.maven.api").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "org.jboss.forge.scaffold.api").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "org.jboss.forge.scaffoldx.api").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "org.jboss.forge.shell.api").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "org.jboss.seam.render").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "javax.api");
        moduleXml.setContents(XMLParser.toXMLString((Node)module));
        if (!dependenciesAsResourceRoot) {
            this.createDependenciesModule(project, dep);
        }
        this.registerPlugin(pluginName, pluginSlot, apiVersion);
        return moduleDir;
    }

    private List<DependencyResource> getPluginDependencies(Project project, Node module) {
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        ArrayList<DependencyResource> pluginDependencies = new ArrayList<DependencyResource>();
        MavenCoreFacet mvn = (MavenCoreFacet)project.getFacet(MavenCoreFacet.class);
        mvn.setPOM(mvn.getPOM());
        List effectiveDependenciesInScopes = deps.getEffectiveDependenciesInScopes(new ScopeType[]{ScopeType.COMPILE, ScopeType.RUNTIME});
        for (Dependency d : effectiveDependenciesInScopes) {
            if (d.getPackagingTypeEnum().equals((Object)PackagingType.JAR) && !d.getGroupId().equals("org.jboss.forge")) {
                List<DependencyResource> artifacts = this.resolveArtifacts(project, d);
                pluginDependencies.addAll(artifacts);
            }
            if (DependencyBuilder.areEquivalent((Dependency)d, (Dependency)DependencyBuilder.create((String)"org.jboss.forge:forge-javaee-api"))) {
                module.getSingle("dependencies").createChild("module").attribute("name", "org.jboss.forge.javaee.api").attribute("services", "import");
                continue;
            }
            if (DependencyBuilder.areEquivalent((Dependency)d, (Dependency)DependencyBuilder.create((String)"org.jboss.forge:forge-scaffold-api"))) {
                module.getSingle("dependencies").createChild("module").attribute("name", "org.jboss.forge.scaffold.api").attribute("services", "import");
                continue;
            }
            if (DependencyBuilder.areEquivalent((Dependency)d, (Dependency)DependencyBuilder.create((String)"org.jboss.forge:forge-scaffoldx-api"))) {
                module.getSingle("dependencies").createChild("module").attribute("name", "org.jboss.forge.scaffoldx.api").attribute("services", "import");
                continue;
            }
            if (DependencyBuilder.areEquivalent((Dependency)d, (Dependency)DependencyBuilder.create((String)"org.jboss.forge:forge-maven-api"))) {
                module.getSingle("dependencies").createChild("module").attribute("name", "org.jboss.forge.maven.api").attribute("services", "import");
                continue;
            }
            if (!d.getGroupId().equals("org.jboss.forge")) continue;
            ShellMessages.error((ShellPrintWriter)this.shell, (String)("Plugin has a dependency on internal Forge API [" + d + "] - this is not allowed and may cause failures."));
        }
        return pluginDependencies;
    }

    private void writeResourceRoots(Project project, Node module, DirectoryResource directory, Node resources) {
        List<DependencyResource> pluginDependencies = this.getPluginDependencies(project, module);
        for (DependencyResource d : pluginDependencies) {
            String name = d.getName();
            Resource child = directory.getChild(name);
            child.delete();
            FileResource depJar = (FileResource)child.reify(FileResource.class);
            depJar.setContents(d.getResourceInputStream());
            resources.createChild("resource-root").attribute("path", name);
        }
    }

    private void createDependenciesModule(Project project, Dependency dep) {
        DirectoryResource dependencyDir = this.getOrCreatePluginDependenciesModuleDirectory(dep);
        String pluginName = dep.getGroupId() + "." + dep.getArtifactId();
        String pluginSlot = dep.getVersion();
        FileResource moduleXml = (FileResource)dependencyDir.getChild("module.xml");
        moduleXml.delete();
        moduleXml.createNewFile();
        Node module = XMLParser.parse((InputStream)this.getClass().getResourceAsStream(MODULE_TEMPLATE_XML));
        module.attribute("name", pluginName + ".dependencies");
        module.attribute("slot", pluginSlot);
        Node resources = module.getSingle("resources");
        Node dependencies = module.getSingle("dependencies");
        dependencies.createChild("module").attribute("name", "javax.api");
        dependencies.createChild("module").attribute("name", "org.jboss.forge.shell.api");
        this.writeResourceRoots(project, module, dependencyDir, resources);
        moduleXml.setContents(XMLParser.toXMLString((Node)module));
    }

    private List<DependencyResource> resolveArtifacts(Project project, Dependency dep) {
        Dependency d = dep;
        List<Object> artifacts = new ArrayList<DependencyResource>();
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        for (Dependency d2 : deps.getDependencies()) {
            if (!DependencyBuilder.areEquivalent((Dependency)d, (Dependency)d2) || d2.getVersion() == null) continue;
            d = d2;
            break;
        }
        if (artifacts.size() != 1) {
            artifacts = this.resolver.resolveArtifacts(d, deps.getRepositories());
        }
        if (artifacts.size() != 1) {
            ShellMessages.warn((ShellPrintWriter)this.shell, (String)("Could not resolve dependency [" + d.toCoordinates() + "]"));
        }
        return artifacts;
    }

    private void registerPlugin(String pluginName, String pluginSlot, String apiVersion) {
        String runtimeVersion = InstalledPluginRegistry.getRuntimeAPIVersion();
        if (!InstalledPluginRegistry.isApiCompatible((CharSequence)runtimeVersion, apiVersion)) {
            throw new RuntimeException("Could not install plugin [" + pluginName + "] because it references Forge API version [" + apiVersion + "] which may not be compatible with my current version [" + runtimeVersion + "]. Please consider upgrading forge, by typing 'forge update'. Otherwise, try installing an older version of the plugin.");
        }
        PluginEntry entry = InstalledPluginRegistry.install(pluginName, apiVersion, pluginSlot);
        this.pluginInstalledEvent.fire((Object)new PluginInstalled(entry));
    }

    private DirectoryResource getOrCreatePluginModuleDirectory(Dependency dep) {
        DirectoryResource pluginDir = this.environment.getPluginDirectory();
        List<String> groupId = Arrays.asList(dep.getGroupId().split("\\."));
        List<String> artifactId = Arrays.asList(dep.getArtifactId().split("\\."));
        DirectoryResource dir = pluginDir;
        for (String segment : groupId) {
            dir = dir.getOrCreateChildDirectory(segment);
        }
        for (String segment : artifactId) {
            dir = dir.getOrCreateChildDirectory(segment);
        }
        dir = dir.getOrCreateChildDirectory(dep.getVersion());
        return dir;
    }

    private DirectoryResource getOrCreatePluginDependenciesModuleDirectory(Dependency dep) {
        DirectoryResource pluginDir = this.environment.getPluginDirectory();
        List<String> groupId = Arrays.asList(dep.getGroupId().split("\\."));
        List<String> artifactId = Arrays.asList(dep.getArtifactId().split("\\."));
        DirectoryResource dir = pluginDir;
        for (String segment : groupId) {
            dir = dir.getOrCreateChildDirectory(segment);
        }
        for (String segment : artifactId) {
            dir = dir.getOrCreateChildDirectory(segment);
        }
        dir = dir.getOrCreateChildDirectory("dependencies");
        dir = dir.getOrCreateChildDirectory(dep.getVersion());
        return dir;
    }
}

