/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.git.GitUtils;
import org.jboss.forge.parser.java.util.Assert;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.dependencies.CompositeDependencyFilter;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyFilter;
import org.jboss.forge.project.dependencies.DependencyQuery;
import org.jboss.forge.project.dependencies.DependencyQueryBuilder;
import org.jboss.forge.project.dependencies.DependencyRepository;
import org.jboss.forge.project.dependencies.DependencyRepositoryImpl;
import org.jboss.forge.project.dependencies.DependencyResolver;
import org.jboss.forge.project.dependencies.NonSnapshotDependencyFilter;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.resources.DependencyResource;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.InstalledPluginRegistry;
import org.jboss.forge.shell.PluginEntry;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.Wait;
import org.jboss.forge.shell.events.ReinitializeEnvironment;
import org.jboss.forge.shell.exceptions.AbortedException;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.PluginManager;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.plugins.builtin.IndexPluginNameCompleter;
import org.jboss.forge.shell.plugins.builtin.InstalledPluginCompleter;
import org.jboss.forge.shell.util.Files;
import org.jboss.forge.shell.util.PluginRef;
import org.jboss.forge.shell.util.PluginUtil;

@Alias(value="forge")
@Topic(value="Shell Environment")
@Help(value="Forge control and writer environment commands. Manage plugins and other forge addons.")
public class ForgePlugin
implements Plugin {
    private final Event<ReinitializeEnvironment> reinitializeEvent;
    private final PluginManager pluginManager;
    private final DependencyResolver resolver;
    private final ForgeEnvironment environment;
    private final ShellPrompt prompt;
    private final Shell shell;
    private final Configuration configuration;
    @Inject
    private Wait wait;

    @Inject
    public ForgePlugin(ForgeEnvironment environment, Event<ReinitializeEnvironment> reinitializeEvent, PluginManager pluginManager, ShellPrompt prompt, DependencyResolver resolver, Shell shell, Configuration configuration) {
        this.environment = environment;
        this.reinitializeEvent = reinitializeEvent;
        this.pluginManager = pluginManager;
        this.prompt = prompt;
        this.shell = shell;
        this.resolver = resolver;
        this.configuration = configuration;
    }

    @DefaultCommand
    public void about(PipeOut out) {
        out.println("    _____                    ");
        out.println("   |  ___|__  _ __ __ _  ___ ");
        out.println("   | |_ / _ \\| `__/ _` |/ _ \\  " + out.renderColor(ShellColor.YELLOW, "\\\\"));
        out.println("   |  _| (_) | | | (_| |  __/  " + out.renderColor(ShellColor.YELLOW, "//"));
        out.println("   |_|  \\___/|_|  \\__, |\\___| ");
        out.println("                   |___/      ");
        out.println("");
        out.print(ShellColor.ITALIC, "JBoss Forge");
        out.print(", version [ ");
        out.print(ShellColor.BOLD, this.environment.getRuntimeVersion());
        out.print(" ] - JBoss, by ");
        out.print(ShellColor.RED, "Red Hat, Inc.");
        out.println(" [ http://forge.jboss.org ]");
    }

    @Command(value="restart", help="Reload all plugins and default configurations")
    public void restart() throws Exception {
        this.reinitializeEvent.fire((Object)new ReinitializeEnvironment());
    }

    @Command(value="list-plugins", help="List all installed plugin JAR files.")
    public void listInstalled(PipeOut out, String input) {
        List<PluginEntry> plugins = InstalledPluginRegistry.list();
        for (PluginEntry plugin : plugins) {
            if (!Strings.isNullOrEmpty((String)input) && !plugin.toString().contains(input)) continue;
            out.println(plugin.toString());
        }
    }

    @Command(value="find-plugin", help="Searches the configured Forge plugin index for a plugin matching the given search text")
    public void find(@Option(description="search string") String searchString, PipeOut out) throws Exception {
        List<PluginRef> pluginList = PluginUtil.findPlugin(this.shell, this.configuration, searchString);
        if (!pluginList.isEmpty()) {
            out.println();
        }
        for (PluginRef ref : pluginList) {
            out.println(" - " + out.renderColor(ShellColor.BOLD, ref.getName()) + " (" + ref.getArtifact() + ")");
            out.println("\tAuthor: " + ref.getAuthor());
            out.println("\tWebsite: " + ref.getWebsite());
            out.println("\tLocation: " + ref.getLocation());
            out.println("\tTags: " + ref.getTags());
            out.println("\tDescription: " + ref.getDescription());
            out.println();
        }
    }

    @Command(value="remove-plugin", help="Removes a plugin from the current Forge runtime configuration")
    public void removePlugin(@Option(completer=InstalledPluginCompleter.class, description="plugin-name", required=true, help="The fully qualified plugin name e.g: 'org.jboss.forge.plugin:version'") String pluginName, PipeOut out) throws Exception {
        if (this.pluginManager.removePlugin(pluginName)) {
            ShellMessages.success((ShellPrintWriter)out, (String)("Successfully removed [" + pluginName + "]"));
            this.restart();
        } else {
            ShellMessages.error((ShellPrintWriter)out, (String)("Failed to remove [" + pluginName + ""));
        }
    }

    @Command(value="install-plugin", help="Installs a plugin from the configured Forge plugin index")
    public void installFromIndex(@Option(description="plugin-name", completer=IndexPluginNameCompleter.class, required=true) String pluginName, @Option(name="version", description="branch, tag, or version to build") String version, PipeOut out) throws Exception {
        PluginRef plugin = PluginUtil.findPluginByName(this.shell, this.configuration, pluginName, true);
        if (plugin == null) {
            throw new RuntimeException("no plugin found with name [" + pluginName + "]");
        }
        ShellMessages.info((ShellPrintWriter)out, (String)("Preparing to install plugin: " + plugin.getName()));
        if (!plugin.isGit()) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        this.installFromGit(plugin.getGitRepo(), Strings.isNullOrEmpty((String)version) ? plugin.getGitRef() : version, null, false, plugin.getArtifact(), out);
    }

    @Command(value="source-plugin", help="Install a plugin from a local project folder")
    public void installFromLocalProject(@Option(description="project directory", required=true) Resource<?> projectFolder, @Option(name="coordinates", type=PromptType.DEPENDENCY_ID, description="the coordinates for the plugin (if in a multi-module repository)") Dependency coordinates, PipeOut out) throws Exception {
        DirectoryResource workspace = (DirectoryResource)projectFolder.reify(DirectoryResource.class);
        if (workspace == null || !workspace.exists()) {
            throw new IllegalArgumentException("Project folder must be specified.");
        }
        this.pluginManager.installFromProject(workspace, coordinates);
        ShellMessages.success((ShellPrintWriter)out, (String)("Installed from [" + workspace + "] successfully."));
        this.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(value="git-plugin", help="Install a plugin from a public git repository")
    public void installFromGit(@Option(description="git repo", required=true) String gitRepo, @Option(name="ref", description="branch or tag to build") String refName, @Option(name="checkoutDir", description="directory in which to clone the repository") Resource<?> checkoutResource, @Option(name="keepSources", description="keep the sources after checking out", defaultValue="false", flagOnly=true) boolean keepSources, @Option(name="coordinates", type=PromptType.DEPENDENCY_ID, description="the coordinates for the plugin (if in a multi-module repository)") Dependency coordinates, PipeOut out) throws Exception {
        DirectoryResource buildDir;
        if (checkoutResource != null) {
            if (!(checkoutResource instanceof FileResource)) {
                throw new IllegalArgumentException("Checkout dir must be a directory path");
            }
            FileResource checkoutDir = (FileResource)checkoutResource;
            if (checkoutDir.exists()) {
                if (!checkoutDir.isDirectory()) {
                    throw new RuntimeException("Resource " + checkoutDir.getFullyQualifiedName() + " is not a valid directory.");
                }
                buildDir = (DirectoryResource)checkoutDir.reify(DirectoryResource.class);
                if (!this.shell.promptBoolean("Directory " + buildDir.getFullyQualifiedName() + " already exists. Do you want to overwrite?", false)) {
                    throw new AbortedException("Directory " + buildDir.getFullyQualifiedName() + " already exists");
                }
                buildDir.delete(true);
                buildDir.mkdirs();
            } else {
                checkoutDir.mkdirs();
                buildDir = (DirectoryResource)checkoutDir.reify(DirectoryResource.class);
            }
        } else {
            buildDir = this.shell.getCurrentDirectory().createTempResource();
        }
        Git repo = null;
        try {
            ShellMessages.info((ShellPrintWriter)out, (String)("Checking out plugin source files to [" + buildDir.getFullyQualifiedName() + "] via 'git'"));
            repo = GitUtils.clone((DirectoryResource)buildDir, (String)gitRepo);
            Ref ref = null;
            String targetRef = refName;
            if (targetRef == null) {
                targetRef = this.environment.getRuntimeVersion();
            }
            if (targetRef != null) {
                String branchName;
                Map tags = repo.getRepository().getTags();
                ref = (Ref)tags.get(targetRef);
                if (ref == null) {
                    List refs = GitUtils.getRemoteBranches((Git)repo);
                    for (Ref branchRef : refs) {
                        branchName = branchRef.getName();
                        if (branchName == null || !branchName.endsWith(targetRef)) continue;
                        ref = repo.branchCreate().setName(targetRef).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + targetRef).call();
                    }
                }
                if (ref == null) {
                    String version;
                    ArrayList<String> sortedVersions = new ArrayList<String>();
                    for (Ref branchRef : GitUtils.getRemoteBranches((Git)repo)) {
                        branchName = branchRef.getName();
                        if (!InstalledPluginRegistry.isApiCompatible((CharSequence)targetRef, branchName = branchName.replaceFirst("refs/heads/", ""))) continue;
                        sortedVersions.add(branchName);
                    }
                    for (String tag : tags.keySet()) {
                        if (!InstalledPluginRegistry.isApiCompatible((CharSequence)targetRef, tag)) continue;
                        sortedVersions.add(tag);
                    }
                    Collections.sort(sortedVersions);
                    if (!sortedVersions.isEmpty() && InstalledPluginRegistry.isApiCompatible((CharSequence)targetRef, version = (String)sortedVersions.get(sortedVersions.size() - 1)) && (ref = (Ref)tags.get(version)) == null) {
                        ref = repo.branchCreate().setName(version).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + version).call();
                    }
                }
            }
            if (ref == null) {
                ref = repo.getRepository().getRef("master");
            }
            if (ref != null) {
                ShellMessages.info((ShellPrintWriter)out, (String)("Switching to branch/tag [" + ref.getName() + "]"));
                GitUtils.checkout((Git)repo, (Ref)ref, (boolean)false, (CreateBranchCommand.SetupUpstreamMode)CreateBranchCommand.SetupUpstreamMode.TRACK, (boolean)false);
            } else {
                if (refName != null) {
                    throw new RuntimeException("Could not locate ref [" + targetRef + "] in repository [" + repo.getRepository().getDirectory().getAbsolutePath() + "]");
                }
                ShellMessages.warn((ShellPrintWriter)out, (String)("Could not find a Ref matching the current Forge version [" + this.environment.getRuntimeVersion() + "], building Plugin from HEAD."));
            }
            this.pluginManager.installFromProject(buildDir, coordinates);
        }
        catch (Throwable throwable) {
            GitUtils.close(repo);
            if (buildDir != null) {
                if (keepSources) {
                    ShellMessages.info((ShellPrintWriter)out, (String)("Sources are kept in [" + buildDir.getFullyQualifiedName() + "]"));
                } else {
                    ShellMessages.info((ShellPrintWriter)out, (String)("Cleaning up temp workspace [" + buildDir.getFullyQualifiedName() + "]"));
                    buildDir.delete(true);
                }
            }
            throw throwable;
        }
        GitUtils.close((Git)repo);
        if (buildDir != null) {
            if (keepSources) {
                ShellMessages.info((ShellPrintWriter)out, (String)("Sources are kept in [" + buildDir.getFullyQualifiedName() + "]"));
            } else {
                ShellMessages.info((ShellPrintWriter)out, (String)("Cleaning up temp workspace [" + buildDir.getFullyQualifiedName() + "]"));
                buildDir.delete(true);
            }
        }
        ShellMessages.success((ShellPrintWriter)out, (String)("Installed from [" + gitRepo + "] successfully."));
        this.restart();
    }

    @Command(value="update-abort", help="Aborts a previous forge update")
    public void updateAbort() throws IOException {
        DirectoryResource forgeHome = this.environment.getForgeHome();
        DirectoryResource updateDirectory = forgeHome.getChildDirectory(".update");
        if (updateDirectory.exists()) {
            if (updateDirectory.delete(true)) {
                ShellMessages.success((ShellPrintWriter)this.shell, (String)"Update files were deleted. Run 'forge update' if you want to update this installation again.");
            } else {
                ShellMessages.info((ShellPrintWriter)this.shell, (String)"Could not abort. Try to run 'forge update-abort' again");
            }
        } else {
            ShellMessages.info((ShellPrintWriter)this.shell, (String)"No update files found");
        }
    }

    @Command(value="update", help="Update this forge installation")
    public void update() throws IOException {
        if (this.environment.isEmbedded()) {
            ShellMessages.warn((ShellPrintWriter)this.shell, (String)"'forge update' only works when it is run outside of the IDE.");
            this.shell.println("The embedded Forge versions are automatically updated when there is a new version of the JBoss Tools Forge Plugin.");
            this.shell.println("If you want to use the latest version without waiting for a new plugin release, do the following:");
            this.shell.println();
            this.shell.println("1. Download the latest Forge version from http://forge.jboss.org and unzip in any place you may find convenient;");
            this.shell.println("2. In Window->Preferences, look for Forge->Installed Forge Runtimes and add the path to your installation and make it the default runtime choice;");
            this.shell.println("3. Start the Forge Console. You should see it is running the latest version.");
            return;
        }
        DirectoryResource forgeHome = this.environment.getForgeHome();
        DirectoryResource updateDir = forgeHome.getChildDirectory(".update");
        if (updateDir.exists()) {
            ShellMessages.warn((ShellPrintWriter)this.shell, (String)"There is an update pending. Restart Forge for the update to take effect. To abort this update, type 'forge update-abort'");
            return;
        }
        Dependency forgeDistribution = this.getLatestAvailableDistribution();
        if (forgeDistribution == null) {
            ShellMessages.info((ShellPrintWriter)this.shell, (String)"Forge is up to date! Enjoy!");
        } else {
            this.shell.print(ShellColor.YELLOW, "***INFO*** ");
            this.shell.print("This Forge installation will be updated to ");
            this.shell.println(ShellColor.BOLD, forgeDistribution.getVersion());
            if (this.prompt.promptBoolean("Is that ok ?", true)) {
                this.updateForge(forgeDistribution);
            }
        }
    }

    private Dependency getLatestAvailableDistribution() {
        final String runtimeVersion = this.environment.getRuntimeVersion();
        DependencyQueryBuilder query = DependencyQueryBuilder.create((Dependency)DependencyBuilder.create((String)"org.jboss.forge:forge-distribution:::zip")).setFilter((DependencyFilter)new CompositeDependencyFilter(new DependencyFilter[]{new NonSnapshotDependencyFilter(), new DependencyFilter(){

            public boolean accept(Dependency dependency) {
                String version = dependency.getVersion();
                return version.compareTo(runtimeVersion) > 0 && version.startsWith("1.") && version.endsWith(".Final");
            }
        }})).setRepositories(new DependencyRepository[]{new DependencyRepositoryImpl(DependencyFacet.KnownRepository.JBOSS_NEXUS)});
        List versions = this.resolver.resolveVersions((DependencyQuery)query);
        return versions.isEmpty() ? null : (Dependency)versions.get(versions.size() - 1);
    }

    private void updateForge(Dependency dependency) throws IOException {
        this.wait.start("Update in progress. Please wait");
        List resolvedArtifacts = this.resolver.resolveArtifacts(dependency);
        Assert.isTrue((resolvedArtifacts.size() == 1 ? 1 : 0) != 0, (String)"Artifact was not found");
        DependencyResource resource = (DependencyResource)resolvedArtifacts.get(0);
        DirectoryResource forgeHome = this.environment.getForgeHome();
        Files.unzip((File)resource.getUnderlyingResourceObject(), (File)forgeHome.getUnderlyingResourceObject());
        DirectoryResource childDirectory = forgeHome.getChildDirectory(dependency.getArtifactId() + "-" + dependency.getVersion());
        DirectoryResource updateDirectory = forgeHome.getChildDirectory(".update");
        if (updateDirectory.exists()) {
            updateDirectory.delete(true);
        }
        childDirectory.renameTo((FileResource)updateDirectory);
        this.wait.stop();
        ShellMessages.success((ShellPrintWriter)this.shell, (String)"Forge\u00a0will now restart\u00a0to complete the update...");
        System.exit(0);
    }
}

