/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.util.GeneralUtils;
import org.jboss.forge.shell.util.PluginRef;
import org.jboss.forge.shell.util.ProxySettings;
import org.yaml.snakeyaml.Yaml;

public class PluginUtil {
    private static final String PROP_GIT_REPOSITORY = "gitrepo";
    private static final String PROP_HOME_MAVEN_REPO = "homerepo";
    private static final String PROP_ARTIFACT = "artifact";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_AUTHOR = "author";
    private static final String PROP_NAME = "name";
    private static final String PROP_WEBSITE = "website";
    private static final String PROP_GIT_REF = "gitref";
    private static final String PROP_TAGS = "tags";

    private static String getDefaultRepo(ForgeEnvironment environment) {
        String defaultRepo = (String)environment.getProperty("DEFAULT_PLUGIN_REPO");
        if (defaultRepo == null) {
            throw new RuntimeException("no default repository set: (to set, type: set DEFAULT_PLUGIN_REPO <repository>)");
        }
        return defaultRepo;
    }

    public static List<PluginRef> findPlugin(Shell shell, Configuration config, String searchString) throws Exception {
        return PluginUtil.findPlugin(shell, config, searchString, true);
    }

    public static List<PluginRef> findPluginSilent(Shell shell, Configuration config, String searchString) throws Exception {
        return PluginUtil.findPlugin(shell, config, searchString, false);
    }

    public static List<PluginRef> findPlugin(Shell shell, Configuration config, String searchString, boolean speak) throws Exception {
        InputStream repoStream = PluginUtil.getPluginRepositoryStream(shell, config, speak);
        return PluginUtil.getPluginsFromRepoStream(searchString, repoStream);
    }

    public static PluginRef findPluginByName(Shell shell, Configuration config, String name, boolean verbose) throws Exception {
        InputStream repoStream = PluginUtil.getPluginRepositoryStream(shell, config, verbose);
        return PluginUtil.getPluginsFromRepoStreamByName(name, repoStream);
    }

    private static InputStream getPluginRepositoryStream(Shell shell, Configuration config, boolean speak) throws IOException, ClientProtocolException {
        String defaultRepo = PluginUtil.getDefaultRepo(shell.getEnvironment());
        InputStream repoStream = PluginUtil.getCachedRepoStream(PluginUtil.getDefaultRepo(shell.getEnvironment()), shell.getEnvironment());
        if (repoStream == null) {
            HttpGet httpGet = new HttpGet(defaultRepo);
            if (speak) {
                shell.print("Connecting to remote repository [" + defaultRepo + "]... ");
            }
            DefaultHttpClient client = new DefaultHttpClient();
            PluginUtil.configureProxy(ProxySettings.fromForgeConfiguration((Configuration)config), client);
            HttpResponse httpResponse = client.execute((HttpUriRequest)httpGet);
            switch (httpResponse.getStatusLine().getStatusCode()) {
                case 200: {
                    if (!speak) break;
                    shell.println("connected!");
                    break;
                }
                case 404: {
                    if (speak) {
                        shell.println("failed! (plugin index not found: " + defaultRepo + ")");
                    }
                    return null;
                }
                default: {
                    if (speak) {
                        shell.println("failed! (server returned status code: " + httpResponse.getStatusLine().getStatusCode());
                    }
                    return null;
                }
            }
            repoStream = httpResponse.getEntity().getContent();
            PluginUtil.setCachedRepoStream(defaultRepo, shell.getEnvironment(), repoStream);
            repoStream = PluginUtil.getCachedRepoStream(PluginUtil.getDefaultRepo(shell.getEnvironment()), shell.getEnvironment());
        }
        return repoStream;
    }

    private static void setCachedRepoStream(String repo, ForgeEnvironment environment, InputStream stream) {
        FileResource cachedRepo = (FileResource)environment.getConfigDirectory().getChildOfType(FileResource.class, repo.replaceAll("[^a-zA-Z0-9]+", "") + ".yaml");
        if (!cachedRepo.exists()) {
            cachedRepo.createNewFile();
        }
        cachedRepo.setContents(stream);
    }

    private static InputStream getCachedRepoStream(String repo, ForgeEnvironment forgeEnvironment) {
        FileResource cachedRepo = (FileResource)forgeEnvironment.getConfigDirectory().getChildOfType(FileResource.class, repo.replaceAll("[^a-zA-Z0-9]+", "") + ".yaml");
        if (cachedRepo.exists()) {
            long lastModified = cachedRepo.getUnderlyingResourceObject().lastModified();
            if (System.currentTimeMillis() - lastModified <= 60000L) {
                return cachedRepo.getResourceInputStream();
            }
            cachedRepo.delete();
        }
        return null;
    }

    private static PluginRef getPluginsFromRepoStreamByName(String name, InputStream stream) {
        if (stream != null) {
            for (Object o : new Yaml().loadAll(stream)) {
                Map map;
                PluginRef ref;
                if (o == null || !name.equalsIgnoreCase((ref = PluginUtil.bindToPuginRef(map = (Map)o)).getName())) continue;
                return ref;
            }
        }
        return null;
    }

    private static List<PluginRef> getPluginsFromRepoStream(String searchString, InputStream stream) {
        ArrayList<PluginRef> pluginList = new ArrayList<PluginRef>();
        if (stream != null) {
            Pattern pattern = Pattern.compile(GeneralUtils.pathspecToRegEx("*" + searchString + "*"));
            for (Object o : new Yaml().loadAll(stream)) {
                Map map;
                PluginRef ref;
                if (o == null || !pattern.matcher((ref = PluginUtil.bindToPuginRef(map = (Map)o)).getName()).matches() && !pattern.matcher(ref.getDescription()).matches() && !pattern.matcher(ref.getTags()).matches()) continue;
                pluginList.add(ref);
            }
        }
        return pluginList;
    }

    private static void configureProxy(ProxySettings proxySettings, DefaultHttpClient client) {
        if (proxySettings != null) {
            HttpHost proxy = new HttpHost(proxySettings.getProxyHost(), proxySettings.getProxyPort());
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            if (proxySettings.isAuthenticationSupported()) {
                AuthScope authScope = new AuthScope(proxySettings.getProxyHost(), proxySettings.getProxyPort());
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxySettings.getProxyUserName(), proxySettings.getProxyPassword());
                client.getCredentialsProvider().setCredentials(authScope, (Credentials)credentials);
            }
        }
    }

    public static void downloadFromURL(PipeOut out, URL url, FileResource<?> resource) throws IOException {
        PluginUtil.downloadFromURL(out, url, resource, true);
    }

    public static void downloadFromURL(PipeOut out, URL url, FileResource<?> resource, boolean speak) throws IOException {
        HttpGet httpGetManifest = new HttpGet(url.toExternalForm());
        if (speak) {
            out.print("Retrieving artifact ... ");
        }
        HttpResponse response = new DefaultHttpClient().execute((HttpUriRequest)httpGetManifest);
        switch (response.getStatusLine().getStatusCode()) {
            case 200: {
                if (speak) {
                    out.println("done.");
                }
                try {
                    resource.setContents(response.getEntity().getContent());
                    if (!speak) break;
                    out.println("done.");
                    break;
                }
                catch (IOException e) {
                    if (!speak) break;
                    out.println("failed to download: " + e.getMessage());
                }
            }
        }
        if (speak) {
            out.println("failed! (server returned status code: " + response.getStatusLine().getStatusCode());
        }
    }

    private static PluginRef bindToPuginRef(Map<String, String> map) {
        PluginRef ref = new PluginRef();
        ref.setName(map.get(PROP_NAME));
        ref.setWebsite(map.get(PROP_WEBSITE));
        ref.setArtifact(map.get(PROP_ARTIFACT));
        ref.setAuthor(map.get(PROP_AUTHOR));
        ref.setDescription(map.get(PROP_DESCRIPTION));
        ref.setTags(map.get(PROP_TAGS));
        ref.setHomeRepo(map.get(PROP_HOME_MAVEN_REPO));
        ref.setGitRepo(map.get(PROP_GIT_REPOSITORY));
        ref.setGitRef(map.get(PROP_GIT_REF));
        return ref;
    }
}

