/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.manager.impl.request;

import java.util.Collections;
import java.util.List;
import org.jboss.forge.furnace.manager.request.AddonActionRequest;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.spi.AddonInfo;

class InstallRequestImpl
implements InstallRequest {
    private final AddonInfo addonInfo;
    private final List<AddonActionRequest> actions;

    public InstallRequestImpl(AddonInfo addonInfo, List<AddonActionRequest> actions) {
        this.addonInfo = addonInfo;
        this.actions = Collections.unmodifiableList(actions);
    }

    public void perform() {
        for (AddonActionRequest action : this.actions) {
            action.perform();
        }
    }

    public List<AddonActionRequest> getActions() {
        return this.actions;
    }

    public AddonInfo getRequestedAddonInfo() {
        return this.addonInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Installation request for [");
        sb.append(this.addonInfo).append("] will: \r\n");
        if (this.actions.isEmpty()) {
            sb.append("Do nothing");
        } else {
            for (AddonActionRequest action : this.actions) {
                sb.append(action.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

