/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.maven.plugin;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Settings;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.impl.FurnaceImpl;
import org.jboss.forge.furnace.manager.impl.AddonManagerImpl;
import org.jboss.forge.furnace.manager.maven.addon.MavenAddonDependencyResolver;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.AddonRepositoryMode;

@Mojo(name="addon-install", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class AddonInstallMojo
extends AbstractMojo {
    @Parameter(property="forge.repository", required=true)
    private File addonRepository;
    @Parameter(property="forge.addonIds", required=true)
    private String[] addonIds;
    @Parameter(defaultValue="forge-addon")
    private String classifier;
    @Parameter(defaultValue="${settings}", required=true, readonly=true)
    private Settings settings;

    public void execute() throws MojoExecutionException, MojoFailureException {
        FurnaceImpl forge = new FurnaceImpl();
        if (!this.addonRepository.exists()) {
            this.addonRepository.mkdirs();
        }
        AddonRepository repository = forge.addRepository(AddonRepositoryMode.MUTABLE, this.addonRepository);
        MavenAddonDependencyResolver addonResolver = new MavenAddonDependencyResolver(this.classifier);
        addonResolver.setSettings(this.settings);
        AddonManagerImpl addonManager = new AddonManagerImpl((Furnace)forge, (AddonDependencyResolver)addonResolver);
        for (String addonId : this.addonIds) {
            AddonId id = AddonId.fromCoordinates((String)addonId);
            InstallRequest install = addonManager.install(id, repository);
            if (install.getActions().isEmpty()) continue;
            this.getLog().info((CharSequence)("" + install));
            install.perform();
        }
    }
}

