/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.core.internal.boot;

import java.io.IOException;
import java.net.URL;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.boot.PlatformURLConnection;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.boot.PlatformURLHandler;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.runtime.CommonMessages;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.util.NLS;

public class PlatformURLBaseConnection
extends PlatformURLConnection {
    public static final String PLATFORM = "base";
    public static final String PLATFORM_URL_STRING = "platform:/base/";
    private static URL installURL;

    public PlatformURLBaseConnection(URL url) {
        super(url);
    }

    @Override
    protected boolean allowCaching() {
        return true;
    }

    @Override
    protected URL resolve() throws IOException {
        String spec = this.url.getFile().trim();
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        if (!spec.startsWith("base/")) {
            String message = NLS.bind(CommonMessages.url_badVariant, this.url);
            throw new IOException(message);
        }
        return spec.length() == PLATFORM.length() + 1 ? installURL : new URL(installURL, spec.substring(PLATFORM.length() + 1));
    }

    public static void startup(URL url) {
        if (installURL != null) {
            return;
        }
        installURL = url;
        PlatformURLHandler.register(PLATFORM, PlatformURLBaseConnection.class);
    }
}

