/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.buddy;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.buddy.IBuddyPolicy;

public class SystemPolicy
implements IBuddyPolicy {
    public static final byte BOOT = 0;
    public static final byte EXT = 1;
    public static final byte APP = 2;
    private static SystemPolicy[] instances = new SystemPolicy[3];
    private ClassLoader classLoader;

    public static SystemPolicy getInstance(final byte type, final ClassLoader bootLoader) {
        if (instances[type] == null) {
            SystemPolicy.instances[type] = new SystemPolicy();
            SystemPolicy.instances[type].classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return SystemPolicy.createClassLoader(type, bootLoader);
                }
            });
        }
        return instances[type];
    }

    public SystemPolicy() {
    }

    public SystemPolicy(ClassLoader parent) {
        this.classLoader = parent;
    }

    static ClassLoader createClassLoader(byte type, ClassLoader bootLoader) {
        switch (type) {
            case 2: {
                if (ClassLoader.getSystemClassLoader() != null) {
                    return ClassLoader.getSystemClassLoader();
                }
                return bootLoader;
            }
            case 0: {
                return bootLoader;
            }
            case 1: {
                if (ClassLoader.getSystemClassLoader() != null) {
                    return ClassLoader.getSystemClassLoader().getParent();
                }
                return bootLoader;
            }
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String name) {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public URL loadResource(String name) {
        return this.classLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> loadResources(String name) {
        try {
            return this.classLoader.getResources(name);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

