/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.Channel;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.LatestVersionNotAvailableException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenChannelDescription;
import org.jboss.galleon.universe.maven.MavenLatestVersionNotAvailableException;
import org.jboss.galleon.universe.maven.MavenProducerBase;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersion;
import org.jboss.galleon.util.StringUtils;

public class MavenChannel
implements Channel,
MavenChannelDescription {
    private final String name;
    private final String versionRange;
    private final MavenProducerBase producer;
    private final String versionIncludeRegex;
    private final String versionExcludeRegex;
    private final Pattern versionIncludePattern;
    private final Pattern versionExcludePattern;

    public MavenChannel(MavenProducerBase producer, String name, String versionRange) throws MavenUniverseException {
        this(producer, name, versionRange, null, null);
    }

    public MavenChannel(MavenProducerBase producer, String name, String versionRange, String versionIncludeRegex, String versionExcludeRegex) throws MavenUniverseException {
        assert (name != null) : "Producer name is missing";
        assert (versionRange != null) : "Producer version-range is missing";
        this.name = name;
        this.versionRange = versionRange;
        this.producer = producer;
        this.versionIncludeRegex = versionIncludeRegex;
        this.versionExcludeRegex = versionExcludeRegex;
        this.versionIncludePattern = versionIncludeRegex == null ? null : Pattern.compile(versionIncludeRegex);
        this.versionExcludePattern = versionExcludeRegex == null ? null : Pattern.compile(versionExcludeRegex);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getLatestBuild(FeaturePackLocation fpl) throws ProvisioningException {
        MavenArtifact artifact = new MavenArtifact();
        artifact.setGroupId(this.producer.getFeaturePackGroupId());
        artifact.setArtifactId(this.producer.getFeaturePackArtifactId());
        artifact.setExtension("zip");
        artifact.setVersionRange(this.versionRange);
        try {
            return this.producer.getRepo().getLatestVersion(artifact, this.getFrequency(fpl), this.versionIncludePattern, this.versionExcludePattern);
        }
        catch (MavenLatestVersionNotAvailableException e) {
            if (fpl.getFrequency() == null && this.producer.hasDefaultFrequency()) {
                fpl = new FeaturePackLocation(fpl.getUniverse(), fpl.getProducerName(), fpl.getChannelName(), this.producer.getDefaultFrequency(), null);
            }
            throw new LatestVersionNotAvailableException(fpl);
        }
        catch (MavenUniverseException e) {
            throw e;
        }
    }

    public List<String> getAllBuilds(FeaturePackLocation fpl) throws ProvisioningException {
        MavenArtifact artifact = new MavenArtifact();
        artifact.setGroupId(this.producer.getFeaturePackGroupId());
        artifact.setArtifactId(this.producer.getFeaturePackArtifactId());
        artifact.setExtension("zip");
        artifact.setVersionRange(this.versionRange);
        try {
            return this.producer.getRepo().getAllVersions(artifact, this.versionIncludePattern, this.versionExcludePattern);
        }
        catch (MavenLatestVersionNotAvailableException e) {
            if (fpl.getFrequency() == null && this.producer.hasDefaultFrequency()) {
                fpl = new FeaturePackLocation(fpl.getUniverse(), fpl.getProducerName(), fpl.getChannelName(), this.producer.getDefaultFrequency(), null);
            }
            throw new LatestVersionNotAvailableException(fpl);
        }
        catch (MavenUniverseException e) {
            throw e;
        }
    }

    public Path resolve(FeaturePackLocation fpl) throws MavenUniverseException {
        MavenArtifact artifact = new MavenArtifact();
        artifact.setGroupId(this.producer.getFeaturePackGroupId());
        artifact.setArtifactId(this.producer.getFeaturePackArtifactId());
        artifact.setExtension("zip");
        if (fpl.getBuild() == null) {
            artifact.setVersionRange(this.versionRange);
            this.producer.getRepo().resolveLatestVersion(artifact, this.getFrequency(fpl), this.versionIncludePattern, this.versionExcludePattern);
        } else {
            artifact.setVersion(fpl.getBuild());
            this.producer.getRepo().resolve(artifact);
        }
        return artifact.getPath();
    }

    public String getFeaturePackGroupId() {
        return this.producer.getFeaturePackGroupId();
    }

    public String getFeaturePackArtifactId() {
        return this.producer.getFeaturePackArtifactId();
    }

    public Collection<String> getFrequencies() {
        return this.producer.getFrequencies();
    }

    @Override
    public String getVersionRange() {
        return this.versionRange;
    }

    @Override
    public String getVersionIncludeRegex() {
        return this.versionIncludeRegex;
    }

    @Override
    public String getVersionExcludeRegex() {
        return this.versionExcludeRegex;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getFeaturePackArtifactId().hashCode();
        result = 31 * result + this.getFeaturePackGroupId().hashCode();
        result = 31 * result + this.getFrequencies().hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.versionRange == null ? 0 : this.versionRange.hashCode());
        result = 31 * result + (this.versionIncludeRegex == null ? 0 : this.versionIncludeRegex.hashCode());
        result = 31 * result + (this.versionExcludeRegex == null ? 0 : this.versionExcludeRegex.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenChannel other = (MavenChannel)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.versionRange == null ? other.versionRange != null : !this.versionRange.equals(other.versionRange)) {
            return false;
        }
        if (this.versionIncludeRegex == null ? other.versionIncludeRegex != null : !this.versionIncludeRegex.equals(other.versionIncludeRegex)) {
            return false;
        }
        if (this.versionExcludeRegex == null ? other.versionExcludeRegex != null : !this.versionExcludeRegex.equals(other.versionExcludeRegex)) {
            return false;
        }
        if (!this.getFeaturePackArtifactId().equals(other.getFeaturePackArtifactId())) {
            return false;
        }
        if (!this.getFeaturePackGroupId().equals(other.getFeaturePackGroupId())) {
            return false;
        }
        return this.getFrequencies().equals(other.getFrequencies());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[channel ").append(this.name);
        buf.append(" groupId=").append(this.getFeaturePackGroupId());
        buf.append(" artifactId=").append(this.getFeaturePackArtifactId());
        buf.append(" version-range=").append(this.versionRange);
        buf.append(" versionIncludeRegex=").append(this.versionIncludeRegex);
        buf.append(" versionExcludeRegex").append(this.versionExcludeRegex);
        buf.append(" frequencies=");
        StringUtils.append((StringBuilder)buf, this.getFrequencies());
        return buf.toString();
    }

    private String getFrequency(FeaturePackLocation fpl) throws MavenUniverseException {
        String frequency = fpl.getFrequency();
        if (frequency == null) {
            return this.producer.getDefaultFrequency();
        }
        if (!this.producer.getFrequencies().contains(frequency)) {
            throw new MavenUniverseException(Errors.frequencyNotSupported((Collection)this.producer.getFrequencies(), (FeaturePackLocation)fpl));
        }
        return frequency;
    }

    public boolean isResolved(FeaturePackLocation fpl) throws ProvisioningException {
        MavenArtifact artifact = new MavenArtifact();
        artifact.setGroupId(this.producer.getFeaturePackGroupId());
        artifact.setArtifactId(this.producer.getFeaturePackArtifactId());
        artifact.setExtension("zip");
        if (fpl.getBuild() == null) {
            artifact.setVersionRange(this.versionRange);
            return this.producer.getRepo().isLatestVersionResolved(artifact, this.getFrequency(fpl));
        }
        artifact.setVersion(fpl.getBuild());
        return this.producer.getRepo().isResolved(artifact);
    }

    public String getLatestBuild(FeaturePackLocation.FPID fpid) throws ProvisioningException {
        MavenArtifact artifact = new MavenArtifact();
        artifact.setGroupId(this.producer.getFeaturePackGroupId());
        artifact.setArtifactId(this.producer.getFeaturePackArtifactId());
        artifact.setExtension("zip");
        artifact.setVersionRange(this.versionRange);
        try {
            return this.producer.getRepo().getLatestVersion(artifact, null, this.versionIncludePattern, this.versionExcludePattern);
        }
        catch (MavenLatestVersionNotAvailableException e) {
            throw new LatestVersionNotAvailableException(fpid.getLocation());
        }
        catch (MavenUniverseException e) {
            throw e;
        }
    }

    public boolean isDevBuild(FeaturePackLocation.FPID fpid) {
        return new MavenArtifactVersion(fpid.getBuild()).isSnapshot();
    }
}

