/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.resourceadapter.v10;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.common.v10.CommonConnDef;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapters;
import org.jboss.jca.common.api.metadata.resourceadapter.v10.ResourceAdapter;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.MetadataParser;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.v10.CommonIronJacamarParser;
import org.jboss.jca.common.metadata.resourceadapter.ResourceAdaptersImpl;
import org.jboss.jca.common.metadata.resourceadapter.v10.ResourceAdapterImpl;
import org.jboss.logging.Messages;

public class ResourceAdapterParser
extends CommonIronJacamarParser
implements MetadataParser<ResourceAdapters> {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceAdapters parse(InputStream xmlInputStream) throws Exception {
        XMLStreamReader reader = null;
        Object adapters = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        reader = inputFactory.createXMLStreamReader(xmlInputStream);
        try {
            ResourceAdapters resourceAdapters = this.parse(reader);
            return resourceAdapters;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public ResourceAdapters parse(XMLStreamReader reader) throws Exception {
        int iterate;
        ResourceAdapters adapters = null;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        block1 : switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                switch (Tag.forName(reader.getLocalName())) {
                    case RESOURCE_ADAPTERS: {
                        adapters = this.parseResourceAdapters(reader);
                        break block1;
                    }
                }
                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return adapters;
    }

    private ResourceAdapters parseResourceAdapters(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        ArrayList<ResourceAdapter> resourceAdapters = new ArrayList<ResourceAdapter>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.RESOURCE_ADAPTERS) {
                        resourceAdapters.trimToSize();
                        return new ResourceAdaptersImpl(resourceAdapters);
                    }
                    if (ResourceAdapters.Tag.forName((String)reader.getLocalName()) != ResourceAdapters.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (ResourceAdapters.Tag.forName((String)reader.getLocalName())) {
                        case RESOURCE_ADAPTER: {
                            resourceAdapters.add(this.parseResourceAdapter(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private ResourceAdapter parseResourceAdapter(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        ArrayList<CommonConnDef> connectionDefinitions = null;
        ArrayList<CommonAdminObject> adminObjects = null;
        ArrayList<String> beanValidationGroups = null;
        String bootstrapContext = null;
        String archive = null;
        TransactionSupportEnum transactionSupport = null;
        HashMap<String, String> configProperties = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapters.Tag.forName((String)reader.getLocalName()) == ResourceAdapters.Tag.RESOURCE_ADAPTER) {
                        return new ResourceAdapterImpl(archive, transactionSupport, connectionDefinitions, adminObjects, configProperties, beanValidationGroups, bootstrapContext);
                    }
                    if (ResourceAdapter.Tag.forName((String)reader.getLocalName()) != ResourceAdapter.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (ResourceAdapter.Tag.forName((String)reader.getLocalName())) {
                        case ADMIN_OBJECTS: 
                        case CONNECTION_DEFINITIONS: 
                        case BEAN_VALIDATION_GROUPS: {
                            break block0;
                        }
                        case ADMIN_OBJECT: {
                            if (adminObjects == null) {
                                adminObjects = new ArrayList<CommonAdminObject>();
                            }
                            adminObjects.add(this.parseAdminObjects(reader));
                            break block0;
                        }
                        case CONNECTION_DEFINITION: {
                            if (connectionDefinitions == null) {
                                connectionDefinitions = new ArrayList<CommonConnDef>();
                            }
                            connectionDefinitions.add(this.parseConnectionDefinitions(reader));
                            break block0;
                        }
                        case BEAN_VALIDATION_GROUP: {
                            if (beanValidationGroups == null) {
                                beanValidationGroups = new ArrayList<String>();
                            }
                            beanValidationGroups.add(this.elementAsString(reader));
                            break block0;
                        }
                        case BOOTSTRAP_CONTEXT: {
                            bootstrapContext = this.elementAsString(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY: {
                            if (configProperties == null) {
                                configProperties = new HashMap<String, String>();
                            }
                            configProperties.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block0;
                        }
                        case TRANSACTION_SUPPORT: {
                            transactionSupport = TransactionSupportEnum.valueOf((String)this.elementAsString(reader));
                            break block0;
                        }
                        case ARCHIVE: {
                            archive = this.elementAsString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    public static enum Tag {
        UNKNOWN(null),
        RESOURCE_ADAPTERS("resource-adapters");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

