/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds.v10;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.v10.DataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ds.DataSourceAbstractImpl;
import org.jboss.logging.Messages;

public class DataSourceImpl
extends DataSourceAbstractImpl
implements DataSource {
    private static final long serialVersionUID = 2L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    protected final Boolean jta;
    protected final String connectionUrl;
    protected String driverClass;
    protected String dataSourceClass;
    protected final String driver;
    protected final HashMap<String, String> connectionProperties;
    protected final String newConnectionSql;
    protected final CommonPool pool;

    public DataSourceImpl(String connectionUrl, String driverClass, String dataSourceClass, String driver, TransactionIsolation transactionIsolation, Map<String, String> connectionProperties, TimeOut timeOut, DsSecurity security, Statement statement, Validation validation, String urlDelimiter, String urlSelectorStrategyClassName, String newConnectionSql, Boolean useJavaContext, String poolName, Boolean enabled, String jndiName, Boolean spy, Boolean useccm, Boolean jta, CommonPool pool) throws ValidateException {
        super(transactionIsolation, timeOut, security, statement, validation, urlDelimiter, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, useccm);
        this.jta = jta;
        this.connectionUrl = connectionUrl;
        this.driverClass = driverClass;
        this.dataSourceClass = dataSourceClass;
        this.driver = driver;
        if (connectionProperties != null) {
            this.connectionProperties = new HashMap(connectionProperties.size());
            this.connectionProperties.putAll(connectionProperties);
        } else {
            this.connectionProperties = new HashMap(0);
        }
        this.newConnectionSql = newConnectionSql;
        this.pool = pool;
        this.validate();
    }

    public Boolean isJTA() {
        return this.jta;
    }

    public final String getConnectionUrl() {
        return this.connectionUrl;
    }

    public final String getDriverClass() {
        return this.driverClass;
    }

    public final String getDataSourceClass() {
        return this.dataSourceClass;
    }

    public final String getDriver() {
        return this.driver;
    }

    public final Map<String, String> getConnectionProperties() {
        return Collections.unmodifiableMap(this.connectionProperties);
    }

    public final Statement getStatement() {
        return this.statement;
    }

    public final String getUrlDelimiter() {
        return this.urlDelimiter;
    }

    public final String getUrlSelectorStrategyClassName() {
        return this.urlSelectorStrategyClassName;
    }

    public final String getNewConnectionSql() {
        return this.newConnectionSql;
    }

    public CommonPool getPool() {
        return this.pool;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.connectionProperties == null ? 0 : this.connectionProperties.hashCode());
        result = 31 * result + (this.connectionUrl == null ? 0 : this.connectionUrl.hashCode());
        result = 31 * result + (this.driver == null ? 0 : this.driver.hashCode());
        result = 31 * result + (this.driverClass == null ? 0 : this.driverClass.hashCode());
        result = 31 * result + (this.dataSourceClass == null ? 0 : this.dataSourceClass.hashCode());
        result = 31 * result + (this.newConnectionSql == null ? 0 : this.newConnectionSql.hashCode());
        result = 31 * result + (this.pool == null ? 0 : this.pool.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DataSourceImpl)) {
            return false;
        }
        DataSourceImpl other = (DataSourceImpl)obj;
        if (this.connectionProperties == null ? other.connectionProperties != null : !this.connectionProperties.equals(other.connectionProperties)) {
            return false;
        }
        if (this.connectionUrl == null ? other.connectionUrl != null : !this.connectionUrl.equals(other.connectionUrl)) {
            return false;
        }
        if (this.driver == null ? other.driver != null : !this.driver.equals(other.driver)) {
            return false;
        }
        if (this.driverClass == null ? other.driverClass != null : !this.driverClass.equals(other.driverClass)) {
            return false;
        }
        if (this.dataSourceClass == null ? other.dataSourceClass != null : !this.dataSourceClass.equals(other.dataSourceClass)) {
            return false;
        }
        if (this.newConnectionSql == null ? other.newConnectionSql != null : !this.newConnectionSql.equals(other.newConnectionSql)) {
            return false;
        }
        return !(this.pool == null ? other.pool != null : !this.pool.equals(other.pool));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<datasource");
        if (this.jndiName != null) {
            sb.append(" ").append(DataSource.Attribute.JNDI_NAME).append("=\"").append(this.jndiName).append("\"");
        }
        if (this.poolName != null) {
            sb.append(" ").append(DataSource.Attribute.POOL_NAME).append("=\"").append(this.poolName).append("\"");
        }
        if (this.enabled != null) {
            sb.append(" ").append(DataSource.Attribute.ENABLED).append("=\"").append(this.enabled).append("\"");
        }
        if (this.useJavaContext != null) {
            sb.append(" ").append(DataSource.Attribute.USE_JAVA_CONTEXT);
            sb.append("=\"").append(this.useJavaContext).append("\"");
        }
        if (this.spy != null) {
            sb.append(" ").append(DataSource.Attribute.SPY).append("=\"").append(this.spy).append("\"");
        }
        if (this.useCcm != null) {
            sb.append(" ").append(DataSource.Attribute.USE_CCM).append("=\"").append(this.useCcm).append("\"");
        }
        if (this.jta != null) {
            sb.append(" ").append(DataSource.Attribute.JTA).append("=\"").append(this.jta).append("\"");
        }
        sb.append(">");
        if (this.connectionUrl != null) {
            sb.append("<").append(DataSource.Tag.CONNECTION_URL).append(">");
            sb.append(this.connectionUrl);
            sb.append("</").append(DataSource.Tag.CONNECTION_URL).append(">");
        }
        if (this.driverClass != null) {
            sb.append("<").append(DataSource.Tag.DRIVER_CLASS).append(">");
            sb.append(this.driverClass);
            sb.append("</").append(DataSource.Tag.DRIVER_CLASS).append(">");
        }
        if (this.dataSourceClass != null) {
            sb.append("<").append(DataSource.Tag.DATASOURCE_CLASS).append(">");
            sb.append(this.dataSourceClass);
            sb.append("</").append(DataSource.Tag.DATASOURCE_CLASS).append(">");
        }
        if (this.driver != null) {
            sb.append("<").append(DataSource.Tag.DRIVER).append(">");
            sb.append(this.driver);
            sb.append("</").append(DataSource.Tag.DRIVER).append(">");
        }
        if (this.connectionProperties != null && this.connectionProperties.size() > 0) {
            for (Map.Entry<String, String> entry : this.connectionProperties.entrySet()) {
                sb.append("<").append(DataSource.Tag.CONNECTION_PROPERTY);
                sb.append(" name=\"").append(entry.getKey()).append("\">");
                sb.append(entry.getValue());
                sb.append("</").append(DataSource.Tag.CONNECTION_PROPERTY).append(">");
            }
        }
        if (this.newConnectionSql != null) {
            sb.append("<").append(DataSource.Tag.NEW_CONNECTION_SQL).append(">");
            sb.append(this.newConnectionSql);
            sb.append("</").append(DataSource.Tag.NEW_CONNECTION_SQL).append(">");
        }
        if (this.transactionIsolation != null) {
            sb.append("<").append(DataSource.Tag.TRANSACTION_ISOLATION).append(">");
            sb.append(this.transactionIsolation);
            sb.append("</").append(DataSource.Tag.TRANSACTION_ISOLATION).append(">");
        }
        if (this.urlDelimiter != null) {
            sb.append("<").append(DataSource.Tag.URL_DELIMITER).append(">");
            sb.append(this.urlDelimiter);
            sb.append("</").append(DataSource.Tag.URL_DELIMITER).append(">");
        }
        if (this.urlSelectorStrategyClassName != null) {
            sb.append("<").append(DataSource.Tag.URL_SELECTOR_STRATEGY_CLASS_NAME).append(">");
            sb.append(this.urlSelectorStrategyClassName);
            sb.append("</").append(DataSource.Tag.URL_SELECTOR_STRATEGY_CLASS_NAME).append(">");
        }
        if (this.pool != null) {
            sb.append(this.pool);
        }
        if (this.security != null) {
            sb.append(this.security);
        }
        if (this.validation != null) {
            sb.append(this.validation);
        }
        if (this.timeOut != null) {
            sb.append(this.timeOut);
        }
        if (this.statement != null) {
            sb.append(this.statement);
        }
        sb.append("</datasource>");
        return sb.toString();
    }

    public void validate() throws ValidateException {
        if (this.driverClass != null && (this.connectionUrl == null || this.connectionUrl.trim().length() == 0)) {
            throw new ValidateException(bundle.requiredElementMissing(DataSource.Tag.CONNECTION_URL.getLocalName(), this.getClass().getCanonicalName()));
        }
        if (!(this.driverClass != null && this.driverClass.trim().length() != 0 || this.dataSourceClass != null && this.dataSourceClass.trim().length() != 0 || this.driver != null && this.driver.trim().length() != 0)) {
            throw new ValidateException(bundle.requiredElementMissing(DataSource.Tag.DRIVER_CLASS.getLocalName(), this.getClass().getCanonicalName()));
        }
    }

    public final void forceDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public final void forceDataSourceClass(String dataSourceClass) {
        this.dataSourceClass = dataSourceClass;
    }
}

