/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds.v11;

import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.ds.v11.DsXaPool;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonXaPoolImpl;

public class DsXaPoolImpl
extends CommonXaPoolImpl
implements DsXaPool {
    private static final long serialVersionUID = 3261597366235425250L;
    protected final Boolean allowMultipleUsers;

    public DsXaPoolImpl(Integer minPoolSize, Integer maxPoolSize, Boolean prefill, Boolean useStrictMin, FlushStrategy flushStrategy, Boolean isSameRmOverride, Boolean interleaving, Boolean padXid, Boolean wrapXaResource, Boolean noTxSeparatePool, Boolean allowMultipleUsers) throws ValidateException {
        super(minPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, isSameRmOverride, interleaving, padXid, wrapXaResource, noTxSeparatePool);
        this.allowMultipleUsers = allowMultipleUsers;
    }

    public final Boolean isAllowMultipleUsers() {
        return this.allowMultipleUsers;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.allowMultipleUsers == null ? 0 : this.allowMultipleUsers.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DsXaPoolImpl)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DsXaPoolImpl other = (DsXaPoolImpl)obj;
        return !(this.allowMultipleUsers == null ? other.allowMultipleUsers != null : !this.allowMultipleUsers.equals(other.allowMultipleUsers));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<xa-pool>");
        if (this.minPoolSize != null) {
            sb.append("<").append(DsXaPool.Tag.MIN_POOL_SIZE).append(">");
            sb.append(this.minPoolSize);
            sb.append("</").append(DsXaPool.Tag.MIN_POOL_SIZE).append(">");
        }
        if (this.maxPoolSize != null) {
            sb.append("<").append(DsXaPool.Tag.MAX_POOL_SIZE).append(">");
            sb.append(this.maxPoolSize);
            sb.append("</").append(DsXaPool.Tag.MAX_POOL_SIZE).append(">");
        }
        if (this.prefill != null) {
            sb.append("<").append(DsXaPool.Tag.PREFILL).append(">");
            sb.append(this.prefill);
            sb.append("</").append(DsXaPool.Tag.PREFILL).append(">");
        }
        if (this.useStrictMin != null) {
            sb.append("<").append(DsXaPool.Tag.USE_STRICT_MIN).append(">");
            sb.append(this.useStrictMin);
            sb.append("</").append(DsXaPool.Tag.USE_STRICT_MIN).append(">");
        }
        if (this.flushStrategy != null) {
            sb.append("<").append(DsXaPool.Tag.FLUSH_STRATEGY).append(">");
            sb.append(this.flushStrategy);
            sb.append("</").append(DsXaPool.Tag.FLUSH_STRATEGY).append(">");
        }
        if (this.allowMultipleUsers != null && this.allowMultipleUsers.booleanValue()) {
            sb.append("<").append(DsXaPool.Tag.ALLOW_MULTIPLE_USERS).append("/>");
        }
        if (this.isSameRmOverride != null) {
            sb.append("<").append(DsXaPool.Tag.IS_SAME_RM_OVERRIDE).append(">");
            sb.append(this.isSameRmOverride);
            sb.append("</").append(DsXaPool.Tag.IS_SAME_RM_OVERRIDE).append(">");
        }
        if (this.interleaving != null && Boolean.TRUE.equals(this.interleaving)) {
            sb.append("<").append(DsXaPool.Tag.INTERLEAVING).append("/>");
        }
        if (this.noTxSeparatePool != null && Boolean.TRUE.equals(this.noTxSeparatePool)) {
            sb.append("<").append(DsXaPool.Tag.NO_TX_SEPARATE_POOLS).append("/>");
        }
        if (this.padXid != null) {
            sb.append("<").append(DsXaPool.Tag.PAD_XID).append(">");
            sb.append(this.padXid);
            sb.append("</").append(DsXaPool.Tag.PAD_XID).append(">");
        }
        if (this.wrapXaResource != null) {
            sb.append("<").append(DsXaPool.Tag.WRAP_XA_RESOURCE).append(">");
            sb.append(this.wrapXaResource);
            sb.append("</").append(DsXaPool.Tag.WRAP_XA_RESOURCE).append(">");
        }
        sb.append("</xa-pool>");
        return sb.toString();
    }
}

