/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.noopts;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.SystemException;
import org.jboss.jca.core.tx.noopts.TransactionImpl;

public class TxRegistry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ConcurrentMap<Long, TransactionImpl> txs = new ConcurrentHashMap<Long, TransactionImpl>();

    public TransactionImpl getTransaction() {
        return (TransactionImpl)this.txs.get(Thread.currentThread().getId());
    }

    public void startTransaction() {
        Long key = Thread.currentThread().getId();
        TransactionImpl tx = new TransactionImpl(key);
        this.txs.put(key, tx);
    }

    public void commitTransaction() throws SystemException {
        Long key = Thread.currentThread().getId();
        TransactionImpl tx = (TransactionImpl)this.txs.get(key);
        if (tx != null) {
            try {
                tx.commit();
            }
            catch (Throwable t) {
                SystemException se = new SystemException("Error during commit");
                se.initCause(t);
                throw se;
            }
            finally {
                this.txs.remove(key);
            }
        } else {
            throw new IllegalStateException("No transaction to commit");
        }
    }

    public void rollbackTransaction() throws SystemException {
        Long key = Thread.currentThread().getId();
        TransactionImpl tx = (TransactionImpl)this.txs.get(key);
        if (tx != null) {
            try {
                tx.rollback();
            }
            catch (Throwable t) {
                SystemException se = new SystemException("Error during rollback");
                se.initCause(t);
                throw se;
            }
            finally {
                this.txs.remove(key);
            }
        } else {
            throw new IllegalStateException("No transaction to rollback");
        }
    }

    public void assignTransaction(TransactionImpl v) {
        this.txs.put(Thread.currentThread().getId(), v);
    }
}

