/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.listener;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.LocalTransaction;
import jakarta.resource.spi.ManagedConnection;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.listener.ConnectionCacheListener;
import org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.AbstractConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.listener.SecurityActions;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.transaction.LockKey;
import org.jboss.jca.core.connectionmanager.transaction.TransactionSynchronizer;
import org.jboss.jca.core.connectionmanager.tx.TxConnectionManagerImpl;
import org.jboss.jca.core.spi.transaction.ConnectableResource;
import org.jboss.jca.core.spi.transaction.ConnectableResourceListener;
import org.jboss.jca.core.spi.transaction.TxUtils;
import org.jboss.jca.core.spi.transaction.local.LocalXAResource;
import org.jboss.jca.core.tracer.Tracer;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class TxConnectionListener
extends AbstractConnectionListener {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)TxConnectionListener.class.getName());
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private static boolean disableFailedtoEnlist = false;
    private TransactionSynchronization transactionSynchronization;
    private final XAResource xaResource;
    private final int xaResourceTimeout;
    private final AtomicBoolean localTransaction = new AtomicBoolean(false);
    private boolean doDelistResource;
    private boolean doSetRollbackOnly;
    private Boolean enlistmentTrace;

    public TxConnectionListener(ConnectionManager cm, ManagedConnection mc, Pool pool, ManagedConnectionPool mcp, FlushStrategy flushStrategy, Boolean tracking, Boolean enlistmentTrace, XAResource xaResource, int xaResourceTimeout) throws ResourceException {
        super(cm, mc, pool, mcp, flushStrategy, tracking);
        StringTokenizer st;
        String value;
        this.xaResource = xaResource;
        this.xaResourceTimeout = xaResourceTimeout;
        this.doDelistResource = true;
        this.doSetRollbackOnly = true;
        this.enlistmentTrace = enlistmentTrace;
        if (xaResource instanceof LocalXAResource) {
            ((LocalXAResource)xaResource).setConnectionListener((ConnectionListener)this);
        }
        if (xaResource instanceof ConnectableResource) {
            ((ConnectableResource)xaResource).setConnectableResourceListener((ConnectableResourceListener)this);
        }
        if ((value = SecurityActions.getSystemProperty("ironjacamar.no_delist_resource")) != null && !value.trim().equals("")) {
            st = new StringTokenizer(value, ",");
            while (this.doDelistResource && st.hasMoreTokens()) {
                if (!this.getPool().getName().equals(st.nextToken())) continue;
                this.doDelistResource = false;
            }
        }
        if ((value = SecurityActions.getSystemProperty("ironjacamar.no_delist_resource_all")) != null && !value.trim().equals("")) {
            this.doDelistResource = false;
        }
        if ((value = SecurityActions.getSystemProperty("ironjacamar.rollback_on_fatal_error")) != null && !value.trim().equals("")) {
            if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                this.doSetRollbackOnly = Boolean.parseBoolean(value);
            } else {
                st = new StringTokenizer(value, ",");
                while (this.doSetRollbackOnly && st.hasMoreTokens()) {
                    if (!this.getPool().getName().equals(st.nextToken())) continue;
                    this.doSetRollbackOnly = false;
                }
            }
        }
    }

    @Override
    protected CoreLogger getLogger() {
        return log;
    }

    @Override
    public void toPool() {
        super.toPool();
        if (!(this.xaResource instanceof LocalXAResource) && this.xaResourceTimeout > 0) {
            try {
                this.xaResource.setTransactionTimeout(this.xaResourceTimeout);
            }
            catch (XAException e) {
                log.debugf(e, "XAException happend during return for: %s", this.getPool() != null ? this.getPool().getName() : "Unknown");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enlist() throws SystemException {
        TxConnectionManager txConnectionManager;
        if (this.isEnlisted() || this.getState().equals((Object)ConnectionState.DESTROY) || this.getState().equals((Object)ConnectionState.DESTROYED)) {
            return;
        }
        TransactionManager tm = this.getConnectionManager().getTransactionIntegration().getTransactionManager();
        int status = tm.getStatus();
        if (status == 6) {
            if (this.transactionSynchronization != null && this.transactionSynchronization.currentTx != null) {
                String error = "Attempt to use connection outside a transaction when already a tx!";
                log.tracef("%s %s", error, this);
                throw new IllegalStateException(error);
            }
            log.tracef("No transaction, no need to enlist: %s", this);
            return;
        }
        Transaction threadTx = tm.getTransaction();
        if (!(threadTx != null && status == 0 || (txConnectionManager = (TxConnectionManager)this.getConnectionManager()).isAllowMarkedForRollback())) {
            String error = "Transaction " + threadTx + " is not active " + TxUtils.getStatusAsString((int)status);
            log.tracef("%s cl=%s", error, this);
            throw new IllegalStateException(error);
        }
        log.tracef("Pre-enlist: %s threadTx=%s", this, threadTx);
        TransactionSynchronization ourSynchronization = null;
        TransactionSynchronizer synchronizer = null;
        try {
            TransactionSynchronizer.lock(threadTx, this.getConnectionManager().getTransactionIntegration());
        }
        catch (Exception e) {
            this.setTrackByTx(false);
            TxConnectionManagerImpl.rethrowAsSystemException("Exception during lock", threadTx, e);
        }
        try {
            if (!this.isTrackByTx() && this.transactionSynchronization != null) {
                String error = "Can't enlist - already a tx!";
                log.tracef("%s %s", error, this);
                throw new IllegalStateException(error);
            }
            if (this.transactionSynchronization != null && !this.transactionSynchronization.currentTx.equals(threadTx)) {
                String error = "Trying to change transaction " + threadTx + " in enlist!";
                log.tracef("%s %s", error, this);
                throw new IllegalStateException(error);
            }
            try {
                log.tracef("Get synchronizer %s threadTx=%s", this, threadTx);
                synchronizer = TransactionSynchronizer.getRegisteredSynchronizer(threadTx, this.getConnectionManager().getTransactionIntegration());
            }
            catch (Throwable t) {
                this.setTrackByTx(false);
                TxConnectionManagerImpl.rethrowAsSystemException("Cannot register synchronization", threadTx, t);
            }
            if (this.transactionSynchronization == null) {
                TransactionSynchronization synchronization = new TransactionSynchronization(threadTx, this.isTrackByTx());
                synchronizer.addUnenlisted(synchronization);
                this.transactionSynchronization = synchronization;
            }
            ourSynchronization = this.transactionSynchronization;
        }
        finally {
            TransactionSynchronizer.unlock(threadTx, this.getConnectionManager().getTransactionIntegration());
        }
        List<Synchronization> unenlisted = synchronizer.getUnenlisted();
        if (unenlisted != null) {
            try {
                int size = unenlisted.size();
                for (int i = 0; i < size; ++i) {
                    TransactionSynchronization sync = (TransactionSynchronization)unenlisted.get(i);
                    if (!sync.enlist()) continue;
                    synchronizer.addEnlisted(sync);
                }
            }
            finally {
                synchronizer.enlisted();
            }
        }
        log.tracef("Check enlisted %s threadTx=%s", this, threadTx);
        ourSynchronization.checkEnlisted();
        this.setEnlisted(true);
    }

    @Override
    public boolean delist() throws ResourceException {
        log.tracef("delisting %s", this);
        boolean success = true;
        try {
            if (!this.isTrackByTx()) {
                Transaction tx;
                if (this.transactionSynchronization != null) {
                    Transaction tx2 = this.transactionSynchronization.currentTx;
                    TransactionSynchronization synchronization = this.transactionSynchronization;
                    this.transactionSynchronization = null;
                    if (TxUtils.isUncommitted((Transaction)tx2)) {
                        TransactionSynchronizer synchronizer;
                        if (synchronization.enlisted && !(synchronizer = TransactionSynchronizer.getRegisteredSynchronizer(tx2, this.getConnectionManager().getTransactionIntegration())).removeEnlisted(synchronization)) {
                            log.tracef("%s not found in %s", synchronization, synchronizer);
                        }
                        if (!this.getState().equals((Object)ConnectionState.DESTROYED)) {
                            log.tracef("delistResource(%s, TMSUSPEND)", this.getXAResource());
                            boolean suspendResult = tx2.delistResource(this.getXAResource(), 0x2000000);
                            if (Tracer.isEnabled()) {
                                Tracer.delistConnectionListener(this.getPool() != null ? this.getPool().getName() : null, this.getManagedConnectionPool(), this, tx2.toString(), suspendResult, false, true);
                            }
                            if (!suspendResult) {
                                throw new ResourceException(bundle.failureDelistResource(this));
                            }
                            log.tracef("delist-suspend: %s", this);
                        }
                    }
                } else if (!this.getState().equals((Object)ConnectionState.DESTROYED) && this.isManagedConnectionFree() && this.isEnlisted() && this.doDelistResource && this.getConnectionManager().getTransactionIntegration() != null && this.getConnectionManager().getTransactionIntegration().getTransactionManager() != null && TxUtils.isUncommitted((Transaction)(tx = this.getConnectionManager().getTransactionIntegration().getTransactionManager().getTransaction()))) {
                    if (TxUtils.isActive((Transaction)tx)) {
                        log.tracef("delistResource(%s, TMSUCCESS)", this.getXAResource());
                        boolean successResult = tx.delistResource(this.getXAResource(), 0x4000000);
                        if (Tracer.isEnabled()) {
                            Tracer.delistConnectionListener(this.getPool() != null ? this.getPool().getName() : null, this.getManagedConnectionPool(), this, tx.toString(), true, false, true);
                        }
                        if (successResult) {
                            log.tracef("delist-success: %s", this);
                        } else {
                            log.debugf("delist-success failed: %s", this);
                            success = false;
                        }
                    } else {
                        log.tracef("delistResource(%s, TMFAIL)", this.getXAResource());
                        boolean failResult = tx.delistResource(this.getXAResource(), 0x20000000);
                        if (Tracer.isEnabled()) {
                            Tracer.delistConnectionListener(this.getPool() != null ? this.getPool().getName() : null, this.getManagedConnectionPool(), this, tx.toString(), false, false, true);
                        }
                        if (failResult) {
                            log.tracef("delist-fail: %s", this);
                        } else {
                            log.debugf("delist-fail failed: %s", this);
                            success = false;
                        }
                    }
                }
                this.setEnlisted(false);
            }
            log.tracef("delisted %s", this);
            return success;
        }
        catch (ResourceException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new ResourceException(bundle.errorInDelist(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dissociate() throws ResourceException {
        log.tracef("dissociate: %s", this);
        try {
            TransactionManager tm = this.getConnectionManager().getTransactionIntegration().getTransactionManager();
            int status = tm.getStatus();
            log.tracef("dissociate: status=%s", TxUtils.getStatusAsString((int)status));
            if (status != 6) {
                if (this.isEnlisted()) {
                    if (this.doDelistResource) {
                        Transaction tx = tm.getTransaction();
                        boolean delistResult = tx.delistResource(this.getXAResource(), 0x4000000);
                        log.tracef("dissociate: delistResult=%s", delistResult);
                    }
                } else {
                    log.tracef("dissociate: not enlisted (%s)", this);
                }
                if (this.isTrackByTx()) {
                    ManagedConnectionPool mcp = this.getManagedConnectionPool();
                    TransactionSynchronizationRegistry tsr = this.getConnectionManager().getTransactionIntegration().getTransactionSynchronizationRegistry();
                    Lock lock = (Lock)tsr.getResource((Object)LockKey.INSTANCE);
                    if (lock != null) {
                        try {
                            lock.lockInterruptibly();
                        }
                        catch (InterruptedException ie) {
                            Thread.interrupted();
                            throw new ResourceException(bundle.unableObtainLock(), (Throwable)ie);
                        }
                        try {
                            tsr.putResource((Object)mcp, null);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
            }
            this.localTransaction.set(false);
            this.setTrackByTx(false);
            if (this.transactionSynchronization != null) {
                this.transactionSynchronization.cancel();
                this.transactionSynchronization = null;
            }
            this.setEnlisted(false);
        }
        catch (Throwable t) {
            throw new ResourceException(bundle.errorInDissociate(), t);
        }
    }

    protected XAResource getXAResource() {
        return this.xaResource;
    }

    @Override
    public void connectionClosed(ConnectionEvent ce) {
        log.tracef("connectionClosed called mc=%s", this.getManagedConnection());
        if (this.getManagedConnection() != (ManagedConnection)ce.getSource()) {
            throw new IllegalArgumentException("ConnectionClosed event received from wrong ManagedConnection! Expected: " + this.getManagedConnection() + ", actual: " + ce.getSource());
        }
        if (this.getCachedConnectionManager() != null) {
            try {
                this.getCachedConnectionManager().unregisterConnection((ConnectionCacheListener)this.getConnectionManager(), (ConnectionListener)this, ce.getConnectionHandle());
            }
            catch (Throwable t) {
                log.throwableFromUnregisterConnection(t);
            }
        }
        try {
            if (this.wasFreed(ce.getConnectionHandle())) {
                boolean success = this.delist();
                log.tracef("isManagedConnectionFree=true mc=%s", this.getManagedConnection());
                if (success || this.tracking != null && !this.tracking.booleanValue()) {
                    this.getConnectionManager().returnManagedConnection(this, false);
                } else {
                    log.delistingFailed(this.getPool() != null ? this.getPool().getName() : "Unknown", new Exception());
                    this.getConnectionManager().returnManagedConnection(this, true);
                }
            } else {
                log.tracef("isManagedConnectionFree=false mc=%s", this.getManagedConnection());
            }
        }
        catch (Throwable t) {
            log.errorWhileClosingConnectionHandle(t);
            this.getConnectionManager().returnManagedConnection(this, true);
        }
    }

    @Override
    public void localTransactionStarted(ConnectionEvent ce) {
        this.localTransaction.set(true);
    }

    @Override
    public void localTransactionCommitted(ConnectionEvent ce) {
        this.localTransaction.set(false);
    }

    @Override
    public void localTransactionRolledback(ConnectionEvent ce) {
        this.localTransaction.set(false);
    }

    @Override
    public void tidyup() throws ResourceException {
        if (this.localTransaction.get()) {
            LocalTransaction local = null;
            ManagedConnection mc = this.getManagedConnection();
            try {
                local = mc.getLocalTransaction();
            }
            catch (Throwable t) {
                throw new ResourceException(bundle.unfinishedLocalTransaction(this), t);
            }
            if (local == null) {
                throw new ResourceException(bundle.unfinishedLocalTransactionNotProvideLocalTransaction(this));
            }
            local.rollback();
            log.debugf("Unfinished local transaction was rolled back.%s", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void haltCatchFire() {
        if (this.isEnlisted()) {
            if (this.transactionSynchronization != null) {
                this.transactionSynchronization.cancel();
            }
            String txId = "";
            if (this.getConnectionManager().getTransactionIntegration() != null && this.getConnectionManager().getTransactionIntegration().getTransactionManager() != null) {
                Transaction tx = null;
                try {
                    tx = this.getConnectionManager().getTransactionIntegration().getTransactionManager().getTransaction();
                    if (Tracer.isEnabled() && tx != null) {
                        txId = tx.toString();
                    }
                    if (TxUtils.isUncommitted((Transaction)tx) && this.doDelistResource) {
                        log.tracef("connectionErrorOccurred: delistResource(%s, TMFAIL)", this.getXAResource());
                        boolean failResult = tx.delistResource(this.getXAResource(), 0x20000000);
                        if (failResult) {
                            log.tracef("connectionErrorOccurred: delist-fail: %s", this);
                        } else {
                            log.debugf("connectionErrorOccurred: delist-fail failed: %s", this);
                        }
                    }
                }
                catch (Exception e) {
                    log.debugf(e, "connectionErrorOccurred: Exception during delistResource=%s", e.getMessage());
                }
                finally {
                    if (TxUtils.isUncommitted((Transaction)tx) && this.doSetRollbackOnly) {
                        try {
                            tx.setRollbackOnly();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (Tracer.isEnabled()) {
                Tracer.delistConnectionListener(this.getPool() != null ? this.getPool().getName() : null, this.getManagedConnectionPool(), this, txId, false, true, false);
            }
        }
        this.setEnlisted(false);
        this.transactionSynchronization = null;
    }

    @Override
    public boolean isManagedConnectionFree() {
        if (this.isTrackByTx() && this.transactionSynchronization != null) {
            return false;
        }
        return super.isManagedConnectionFree();
    }

    boolean wasFreed(Object handle) {
        if (handle != null) {
            this.unregisterConnection(handle);
        } else {
            if (!this.isTrackByTx()) {
                return false;
            }
            this.setTrackByTx(false);
        }
        return this.isManagedConnectionFree();
    }

    @Override
    protected void toString(StringBuffer buffer) {
        buffer.append(" xaResource=").append(this.xaResource);
        buffer.append(" txSync=").append(this.transactionSynchronization);
    }

    final TransactionSynchronization getTransactionSynchronization() {
        return this.transactionSynchronization;
    }

    final void setTransactionSynchronization(TransactionSynchronization transactionSynchronization) {
        this.transactionSynchronization = transactionSynchronization;
    }

    static {
        String value = SecurityActions.getSystemProperty("ironjacamar.disable_enlistment_trace");
        if (value != null && !value.trim().equals("")) {
            try {
                disableFailedtoEnlist = Boolean.valueOf(value);
            }
            catch (Throwable t) {
                disableFailedtoEnlist = true;
            }
        }
    }

    public class TransactionSynchronization
    implements Synchronization {
        private final Throwable failedToEnlist;
        private final boolean recordEnlist;
        protected final Transaction currentTx;
        private final boolean wasTrackByTx;
        private boolean enlisted;
        private Throwable enlistError;
        private boolean cancel;

        public TransactionSynchronization(Transaction tx, boolean trackByTx) {
            this.currentTx = tx;
            this.wasTrackByTx = trackByTx;
            this.enlisted = false;
            this.enlistError = null;
            this.cancel = false;
            this.recordEnlist = TxConnectionListener.this.enlistmentTrace != null ? TxConnectionListener.this.enlistmentTrace : !disableFailedtoEnlist;
            this.failedToEnlist = this.recordEnlist ? new Throwable("Unabled to enlist resource, see the previous warnings.") : null;
            if (log.isTraceEnabled()) {
                log.tracef("%s: Constructor", this.toString());
            }
        }

        public void cancel() {
            this.cancel = true;
        }

        public void checkEnlisted() throws SystemException {
            if (this.enlistError != null) {
                String error = "Error enlisting resource in transaction=" + this.currentTx;
                log.tracef("%s %s", error, TxConnectionListener.this);
                if (this.recordEnlist && this.enlistError == this.failedToEnlist) {
                    SystemException se = new SystemException(bundle.systemExceptionWhenFailedToEnlistEqualsCurrentTx(this.failedToEnlist, this.currentTx));
                    if (Tracer.isEnabled()) {
                        Tracer.exception(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, se);
                    }
                    throw se;
                }
                SystemException e = new SystemException(error);
                e.initCause(this.enlistError);
                if (Tracer.isEnabled()) {
                    Tracer.exception(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, e);
                }
                throw e;
            }
            if (!this.enlisted) {
                String error = "Resource is not enlisted in transaction=" + this.currentTx;
                log.tracef("%s %s", error, TxConnectionListener.this);
                throw new IllegalStateException("Resource was not enlisted.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean enlist() {
            boolean enlistResult;
            block12: {
                log.tracef("Enlisting resource %s", TxConnectionListener.this);
                try {
                    XAResource resource = TxConnectionListener.this.getXAResource();
                    enlistResult = this.currentTx.enlistResource(resource);
                    if (!enlistResult) {
                        if (Tracer.isEnabled()) {
                            Tracer.enlistConnectionListener(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, this.currentTx.toString(), false, !TxConnectionListener.this.isTrackByTx());
                        }
                        this.enlistError = this.failedToEnlist;
                    } else if (Tracer.isEnabled()) {
                        Tracer.enlistConnectionListener(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, this.currentTx.toString(), true, !TxConnectionListener.this.isTrackByTx());
                    }
                }
                catch (Throwable t) {
                    this.enlistError = t;
                    enlistResult = false;
                    if (!Tracer.isEnabled()) break block12;
                    Tracer.enlistConnectionListener(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, this.currentTx.toString(), false, !TxConnectionListener.this.isTrackByTx());
                }
            }
            if (this.recordEnlist && this.enlistError != null && log.isTraceEnabled()) {
                log.trace("Failed to enlist resource " + TxConnectionListener.this, this.enlistError);
            }
            TransactionSynchronization transactionSynchronization = this;
            synchronized (transactionSynchronization) {
                if (!enlistResult) {
                    TxConnectionListener.this.setTrackByTx(false);
                    TxConnectionListener.this.transactionSynchronization = null;
                } else {
                    this.enlisted = true;
                    log.tracef("Enlisted resource %s", TxConnectionListener.this);
                }
            }
            return enlistResult;
        }

        public void beforeCompletion() {
            block12: {
                if (this.enlisted && !this.cancel) {
                    try {
                        if (this.equals(TxConnectionListener.this.transactionSynchronization) && this.wasTrackByTx && TxConnectionListener.this.doDelistResource) {
                            if (TxUtils.isUncommitted((Transaction)this.currentTx)) {
                                if (TxUtils.isActive((Transaction)this.currentTx)) {
                                    log.tracef("delistResource(%s, TMSUCCESS)", TxConnectionListener.this.getXAResource());
                                    this.currentTx.delistResource(TxConnectionListener.this.getXAResource(), 0x4000000);
                                    if (Tracer.isEnabled()) {
                                        Tracer.delistConnectionListener(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, this.currentTx.toString(), true, false, false);
                                    }
                                } else {
                                    log.tracef("delistResource(%s, TMFAIL)", TxConnectionListener.this.getXAResource());
                                    this.currentTx.delistResource(TxConnectionListener.this.getXAResource(), 0x20000000);
                                    if (Tracer.isEnabled()) {
                                        Tracer.delistConnectionListener(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, this.currentTx.toString(), false, false, false);
                                    }
                                }
                            } else if (log.isTraceEnabled()) {
                                log.tracef("Non-uncommitted transaction for %s (%s)", TxConnectionListener.this, this.currentTx != null ? TxUtils.getStatusAsString((int)this.currentTx.getStatus()) : "None");
                            }
                            break block12;
                        }
                        log.tracef("No delistResource for: %s", TxConnectionListener.this);
                    }
                    catch (Throwable t) {
                        log.beforeCompletionErrorOccured(TxConnectionListener.this, t);
                    }
                } else {
                    log.tracef("Unenlisted resource: %s", TxConnectionListener.this);
                }
            }
        }

        public void afterCompletion(int status) {
            if (TxConnectionListener.this.getState().equals((Object)ConnectionState.DESTROYED)) {
                return;
            }
            if (!this.cancel) {
                if (!this.equals(TxConnectionListener.this.transactionSynchronization)) {
                    if (!this.wasTrackByTx) {
                        TxConnectionListener.this.setEnlisted(false);
                        return;
                    }
                    String message = "afterCompletion called with wrong tx! Expected: " + this + ", actual: " + TxConnectionListener.this.transactionSynchronization;
                    IllegalStateException e = new IllegalStateException(message);
                    log.somethingWrongWithPooling(e);
                }
                TxConnectionListener.this.setEnlisted(false);
                TxConnectionListener.this.transactionSynchronization = null;
                if (this.wasTrackByTx) {
                    log.tracef("afterCompletion(%d) isTrackByTx=%b for %s", status, TxConnectionListener.this.isTrackByTx(), TxConnectionListener.this);
                    if (TxConnectionListener.this.wasFreed(null)) {
                        if (Tracer.isEnabled() && status == 4) {
                            Tracer.delistConnectionListener(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, "", true, true, false);
                        }
                        TxConnectionListener.this.getConnectionManager().returnManagedConnection(TxConnectionListener.this, false);
                    } else if (TxConnectionListener.this.tracking == null || TxConnectionListener.this.tracking.booleanValue()) {
                        log.activeHandles(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : "Unknown", TxConnectionListener.this.connectionHandles.size());
                        if (TxConnectionListener.this.tracking != null && TxConnectionListener.this.tracking.booleanValue()) {
                            for (Map.Entry entry : TxConnectionListener.this.connectionTraces.entrySet()) {
                                log.activeHandle(entry.getKey(), (Exception)entry.getValue());
                            }
                            log.txConnectionListenerBoundary(new Exception());
                        }
                        if (Tracer.isEnabled()) {
                            for (Object c : TxConnectionListener.this.connectionHandles) {
                                Tracer.clearConnection(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, c);
                            }
                        }
                        TxConnectionListener.this.getConnectionManager().returnManagedConnection(TxConnectionListener.this, true);
                    } else if (log.isTraceEnabled()) {
                        log.tracef(new Exception("Connection across boundary"), "ConnectionListener=%s", TxConnectionListener.this);
                    }
                }
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("TransactionSynchronization@").append(System.identityHashCode(this));
            buffer.append("{tx=").append(this.currentTx);
            buffer.append(" wasTrackByTx=").append(this.wasTrackByTx);
            buffer.append(" enlisted=").append(this.enlisted);
            buffer.append(" cancel=").append(this.cancel);
            buffer.append("}");
            return buffer.toString();
        }
    }
}

