/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jboss.ejb.client.remoting.ProtocolV1ClassTable;
import org.jboss.ejb.client.remoting.ProtocolV1ObjectTable;
import org.jboss.ejb.client.remoting.SecurityActions;
import org.jboss.marshalling.AbstractClassResolver;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

abstract class ProtocolMessageHandler {
    ProtocolMessageHandler() {
    }

    protected abstract void processMessage(InputStream var1) throws IOException;

    protected Map<String, Object> readAttachments(ObjectInput input) throws IOException, ClassNotFoundException {
        int numAttachments = input.readByte();
        if (numAttachments == 0) {
            return null;
        }
        HashMap<String, Object> attachments = new HashMap<String, Object>(numAttachments);
        for (int i = 0; i < numAttachments; ++i) {
            String key = (String)input.readObject();
            Object val = input.readObject();
            attachments.put(key, val);
        }
        return attachments;
    }

    protected Unmarshaller prepareForUnMarshalling(MarshallerFactory marshallerFactory, DataInputStream dataInput) throws IOException {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setVersion(2);
        marshallingConfiguration.setClassTable((ClassTable)ProtocolV1ClassTable.INSTANCE);
        marshallingConfiguration.setObjectTable((ObjectTable)ProtocolV1ObjectTable.INSTANCE);
        marshallingConfiguration.setClassResolver((ClassResolver)TCCLClassResolver.INSTANCE);
        Unmarshaller unmarshaller = marshallerFactory.createUnmarshaller(marshallingConfiguration);
        unmarshaller.start(Marshalling.createByteInput((InputStream)dataInput));
        return unmarshaller;
    }

    protected void glueStackTraces(Throwable exception, StackTraceElement[] userStackTrace, int trimCount, String msg) {
        StackTraceElement[] est = exception.getStackTrace();
        StackTraceElement[] fst = Arrays.copyOf(est, est.length + userStackTrace.length - trimCount + 1);
        fst[est.length] = new StackTraceElement("..." + msg + "..", "", null, -1);
        System.arraycopy(userStackTrace, trimCount, fst, est.length + 1, userStackTrace.length - trimCount);
        exception.setStackTrace(fst);
    }

    private static final class TCCLClassResolver
    extends AbstractClassResolver {
        static TCCLClassResolver INSTANCE = new TCCLClassResolver();

        private TCCLClassResolver() {
        }

        protected ClassLoader getClassLoader() {
            return SecurityActions.getContextClassLoader();
        }
    }
}

