/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.scope;

import java.io.Serializable;
import org.jboss.metadata.spi.scope.ScopeLevel;

public class Scope
implements Serializable,
Comparable {
    private static final long serialVersionUID = 5255750644324593360L;
    private final ScopeLevel level;
    private final Object qualifier;
    private final int hashcode;

    public Scope(ScopeLevel level, Object qualifier) {
        if (level == null) {
            throw new IllegalArgumentException("Null level");
        }
        if (qualifier == null) {
            throw new IllegalArgumentException("Null qualifier");
        }
        this.level = level;
        this.qualifier = qualifier;
        this.hashcode = level.hashCode();
    }

    public ScopeLevel getScopeLevel() {
        return this.level;
    }

    public Object getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        return this.level.getName() + "=" + this.qualifier;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Scope)) {
            return false;
        }
        Scope other = (Scope)object;
        if (this.level.compareTo(other.getScopeLevel()) != 0) {
            return false;
        }
        return this.qualifier.equals(other.qualifier);
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        Scope other = (Scope)o;
        return this.level.compareTo(other.getScopeLevel());
    }

    public int hashCode() {
        return this.hashcode;
    }
}

