/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.signature.javassist;

import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.metadata.spi.signature.javassist.JavassistConstructorSignature;
import org.jboss.metadata.spi.signature.javassist.JavassistFieldSignature;
import org.jboss.metadata.spi.signature.javassist.JavassistMethodSignature;

public class JavassistSignatureFactory {
    public static Signature getSignature(CtMember member) {
        if (member == null) {
            throw new IllegalArgumentException("Null member");
        }
        try {
            if (member instanceof CtMethod) {
                CtMethod method = (CtMethod)CtMethod.class.cast(member);
                return new JavassistMethodSignature(method);
            }
            if (member instanceof CtField) {
                CtField field = (CtField)CtField.class.cast(member);
                return new JavassistFieldSignature(field);
            }
            if (member instanceof CtConstructor) {
                CtConstructor constructor = (CtConstructor)CtConstructor.class.cast(member);
                return new JavassistConstructorSignature(constructor);
            }
        }
        catch (NotFoundException e) {
            throw JavassistSignatureFactory.raiseClassNotFound("member", member.toString(), e);
        }
        throw new IllegalArgumentException("Unknown member: " + member);
    }

    public static String[] convertParameters(CtClass[] classes) {
        if (classes == null || classes.length == 0) {
            return Signature.NO_PARAMETERS;
        }
        String[] paramTypes = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            paramTypes[i] = JavassistSignatureFactory.convertName(classes[i]);
        }
        return paramTypes;
    }

    protected static String convertName(CtClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null CtClass");
        }
        CtClass temp = clazz;
        if (temp.isArray()) {
            StringBuilder buffer = new StringBuilder();
            try {
                while (temp.isArray()) {
                    buffer.append('[');
                    temp = temp.getComponentType();
                }
                if (temp.isPrimitive()) {
                    CtPrimitiveType primitive = (CtPrimitiveType)temp;
                    buffer.append(Character.toString(primitive.getDescriptor()));
                } else {
                    buffer.append('L');
                    buffer.append(temp.getName());
                    buffer.append(';');
                }
                return buffer.toString();
            }
            catch (NotFoundException e) {
                throw JavassistSignatureFactory.raiseClassNotFound("class", clazz.getName(), e);
            }
        }
        return clazz.getName();
    }

    protected static NoClassDefFoundError raiseClassNotFound(String type, String info, NotFoundException e) throws NoClassDefFoundError {
        NoClassDefFoundError ex = new NoClassDefFoundError("Unable to find " + type + ": " + info);
        if (e.getCause() != null) {
            ex.initCause(e.getCause());
        }
        throw ex;
    }
}

