/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.io.File;
import java.io.PrintWriter;
import java.net.URI;
import org.jboss.bootstrap.spi.Server;
import org.jboss.logging.Logger;

public class NamingProviderURLWriter {
    public static final String DEFAULT_PERSIST_FILE_NAME = "jnp-service.url";
    private static final Logger log = Logger.getLogger(NamingProviderURLWriter.class);
    private String bootstrapUrl;
    private Server server;
    private URI outputDir;
    private String filename = "jnp-service.url";
    private File outputFile;

    public URI getOutputDirURI() {
        return this.outputDir;
    }

    public void setOutputDirURL(URI dir) {
        this.outputDir = dir;
    }

    public String getOutputFileName() {
        return this.filename == null ? DEFAULT_PERSIST_FILE_NAME : this.filename;
    }

    public void setOutputFileName(String name) {
        this.filename = name;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public String getBootstrapURL() {
        return this.bootstrapUrl;
    }

    public void setBootstrapURL(String url) {
        this.bootstrapUrl = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (this.bootstrapUrl != null) {
            File base = null;
            if (this.outputDir == null) {
                if (this.server != null) {
                    base = this.server.getConfig().getServerDataDir();
                    this.outputDir = base.toURI();
                }
            } else {
                base = new File(this.outputDir);
            }
            if (base != null) {
                base.mkdirs();
                this.outputFile = new File(base, this.getOutputFileName());
                if (this.outputFile.exists()) {
                    this.outputFile.delete();
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Creating file " + this.outputFile));
                }
                this.outputFile.createNewFile();
                PrintWriter writer = new PrintWriter(this.outputFile);
                try {
                    writer.println(this.bootstrapUrl);
                    writer.flush();
                    Object var4_3 = null;
                    this.outputFile.deleteOnExit();
                    writer.close();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.outputFile.deleteOnExit();
                    writer.close();
                    throw throwable;
                }
                this.outputFile.deleteOnExit();
            } else {
                log.warn((Object)("No directory specified for " + this.getOutputFileName() + " cannot write the naming service url. Please configure either " + "the 'server' property or the 'outputDir' property."));
            }
        } else {
            log.debug((Object)"No URLs to write");
        }
    }

    public void stop() throws Exception {
        if (this.outputFile != null) {
            this.outputFile.delete();
        }
    }
}

