/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling.position;

import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.NoopParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.PositionStack;
import org.jboss.xb.binding.sunday.unmarshalling.RepeatableParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SundayContentHandler;
import org.jboss.xb.binding.sunday.unmarshalling.TermBeforeSetParentCallback;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.position.Position;
import org.xml.sax.Attributes;

public abstract class AbstractPosition
implements Position {
    protected static Logger log = Logger.getLogger(AbstractPosition.class);
    protected static boolean trace;
    protected PositionStack stack;
    protected final QName qName;
    protected ParticleBinding particle;
    protected ParticleHandler handler;
    protected TypeBinding parentType;
    protected Object o;
    protected Object repeatableParticleValue;
    protected RepeatableParticleHandler repeatableHandler;
    protected boolean ended;
    protected int occurrence;
    protected Position previous;
    protected Position next;

    public static void resetTrace() {
        trace = log.isTraceEnabled();
    }

    protected AbstractPosition(QName qName, ParticleBinding particle) {
        if (particle == null) {
            throw new IllegalArgumentException("Null particle");
        }
        if (qName == null) {
            throw new IllegalArgumentException("Null qName");
        }
        this.qName = qName;
        this.particle = particle;
        this.occurrence = 1;
    }

    public void setStack(PositionStack stack) {
        this.stack = stack;
    }

    public ParticleBinding getParticle() {
        return this.particle;
    }

    public Position getNext() {
        return this.next;
    }

    public Position getPrevious() {
        return this.previous;
    }

    public void setPrevious(Position previous) {
        this.previous = previous;
    }

    public RepeatableParticleHandler getRepeatableHandler() {
        return this.repeatableHandler;
    }

    public Object getRepeatableParticleValue() {
        return this.repeatableParticleValue;
    }

    public Object getValue() {
        return this.o;
    }

    public void setValue(Object value) {
        this.o = value;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public void setParentType(TypeBinding parentType) {
        this.parentType = parentType;
    }

    public boolean isElement() {
        return false;
    }

    public void initValue(Attributes atts) {
        if (this.handler == null) {
            this.handler = this.getHandler(this.particle.getTerm());
        }
        Object parent = this.previous == null ? null : this.previous.getValue();
        this.o = this.handler.startParticle(parent, this.qName, this.particle, atts, this.stack.getNamespaceRegistry());
    }

    public void startRepeatableParticle() {
        RepeatableParticleHandler repeatableHandler;
        Object repeatableContainer;
        if (trace) {
            log.trace((Object)(" start repeatable " + this.particle.getTerm()));
        }
        if ((repeatableContainer = (repeatableHandler = this.particle.getTerm().getRepeatableHandler()).startRepeatableParticle(this.previous.getValue(), this.qName, this.particle)) != null) {
            if (this.repeatableParticleValue != null) {
                throw new IllegalStateException("Previous repeatable particle hasn't been ended yet!");
            }
            this.repeatableParticleValue = repeatableContainer;
            this.repeatableHandler = repeatableHandler;
        }
    }

    public void endRepeatableParticle() {
        if (trace) {
            log.trace((Object)(" end repeatable " + this.particle.getTerm()));
        }
        this.repeatableHandler.endRepeatableParticle(this.previous.getValue(), this.repeatableParticleValue, this.qName, this.particle, this.previous.getParticle());
        this.repeatableParticleValue = null;
        this.repeatableHandler = null;
    }

    protected Position notSkippedParent() {
        Position wildcardPosition = null;
        for (Position position = this.previous; position != null; position = position.getPrevious()) {
            ParticleBinding particle = position.getParticle();
            if (!particle.getTerm().isSkip() || position.getRepeatableParticleValue() != null) {
                return position;
            }
            if (wildcardPosition != null) {
                return wildcardPosition;
            }
            if (!particle.getTerm().isWildcard()) continue;
            wildcardPosition = position;
        }
        return wildcardPosition;
    }

    protected void setParent(Position parentPosition, ParticleHandler handler) {
        if (this.repeatableParticleValue != null) {
            this.repeatableHandler.addTermValue(this.repeatableParticleValue, this.o, this.qName, this.particle, parentPosition.getParticle(), handler);
        } else if (parentPosition.getRepeatableParticleValue() == null || !parentPosition.getParticle().getTerm().isSkip()) {
            TermBeforeSetParentCallback beforeSetParent = this.particle.getTerm().getBeforeSetParentCallback();
            if (beforeSetParent != null) {
                SundayContentHandler.UnmarshallingContextImpl ctx = this.stack.getContext();
                ctx.parent = parentPosition.getValue();
                ctx.particle = this.particle;
                ctx.parentParticle = this.notSkippedParent().getParticle();
                this.o = beforeSetParent.beforeSetParent(this.o, ctx);
                ctx.clear();
            }
            handler.setParent(parentPosition.getValue(), this.o, this.qName, this.particle, parentPosition.getParticle());
        } else {
            parentPosition.getRepeatableHandler().addTermValue(parentPosition.getRepeatableParticleValue(), this.o, this.qName, this.particle, parentPosition.getParticle(), handler);
        }
    }

    private ParticleHandler getHandler(TermBinding term) {
        ParticleHandler handler = null;
        if (term.isModelGroup()) {
            handler = ((ModelGroupBinding)term).getHandler();
        } else if (term.isWildcard()) {
            handler = NoopParticleHandler.INSTANCE;
        } else {
            throw new IllegalArgumentException("Unexpected term " + term);
        }
        return handler == null ? DefaultHandlers.ELEMENT_HANDLER : handler;
    }
}

