/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling.position;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SundayContentHandler;
import org.jboss.xb.binding.sunday.unmarshalling.TermBeforeSetParentCallback;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.jboss.xb.binding.sunday.unmarshalling.position.AbstractPosition;
import org.jboss.xb.binding.sunday.unmarshalling.position.Position;
import org.jboss.xb.binding.sunday.xop.XOPIncludeHandler;
import org.xml.sax.Attributes;

public class ElementPosition
extends AbstractPosition {
    private ParticleBinding nonXsiParticle;
    private boolean ignoreCharacters;
    private StringBuffer textContent;
    private Boolean indentation;
    private boolean ignorableCharacters = true;
    private Object[] interceptorObjects;

    public ElementPosition(QName qName, ParticleBinding particle) {
        super(qName, particle);
    }

    public boolean isElement() {
        return true;
    }

    public void reset() {
        if (!this.ended) {
            throw new JBossXBRuntimeException("Attempt to reset a particle that has already been reset: " + this.particle.getTerm());
        }
        this.ended = false;
        this.o = null;
        if (this.textContent != null) {
            this.textContent.setLength(0);
        }
        this.indentation = null;
        this.ignorableCharacters = true;
        if (this.nonXsiParticle != null) {
            this.particle = this.nonXsiParticle;
        }
    }

    public ParticleBinding getNonXsiParticle() {
        return this.nonXsiParticle;
    }

    public void setNonXsiParticle(ParticleBinding nonXsiParticle) {
        this.nonXsiParticle = nonXsiParticle;
    }

    public boolean isIgnoreCharacters() {
        return this.ignoreCharacters;
    }

    public void setIgnoreCharacters(boolean ignoreCharacters) {
        this.ignoreCharacters = ignoreCharacters;
    }

    public StringBuffer getTextContent() {
        return this.textContent;
    }

    public Position nextPosition(QName startName, Attributes atts) {
        ModelGroupBinding modelGroup;
        if (this.ended) {
            if (!this.qName.equals(startName)) {
                if (this.repeatableParticleValue != null) {
                    this.endRepeatableParticle();
                }
                return null;
            }
            if (this.particle.isRepeatable()) {
                if (this.particle.isOccurrenceAllowed(this.occurrence + 1)) {
                    this.reset();
                    ++this.occurrence;
                    return this;
                }
                if (this.repeatableParticleValue != null) {
                    this.endRepeatableParticle();
                }
                return null;
            }
            this.reset();
            this.previous.repeatForChild(atts);
            this.occurrence = 1;
            if (this.next != null) {
                this.next.setPrevious(null);
                this.next = null;
            }
            return this;
        }
        ElementBinding element = (ElementBinding)this.particle.getTerm();
        TypeBinding parentType = element.getType();
        ParticleBinding typeParticle = parentType.getParticle();
        ModelGroupBinding modelGroupBinding = modelGroup = typeParticle == null ? null : (ModelGroupBinding)typeParticle.getTerm();
        if (modelGroup == null) {
            if (startName.equals(Constants.QNAME_XOP_INCLUDE)) {
                SchemaBinding schema = element.getSchema();
                TypeBinding anyUriType = schema.getType(Constants.QNAME_ANYURI);
                if (anyUriType == null) {
                    log.warn((Object)("Type " + Constants.QNAME_ANYURI + " not bound."));
                }
                ElementBinding parentElement = (ElementBinding)this.particle.getTerm();
                parentElement.setXopUnmarshaller(schema.getXopUnmarshaller());
                this.flushIgnorableCharacters();
                this.handler = DefaultHandlers.XOP_HANDLER;
                this.ignoreCharacters = true;
                this.initValue(null);
                TypeBinding xopIncludeType = new TypeBinding(new QName("http://www.w3.org/2004/08/xop/include", "Include"));
                xopIncludeType.setSchemaBinding(schema);
                xopIncludeType.addAttribute(new QName("href"), anyUriType, DefaultHandlers.ATTRIBUTE_HANDLER);
                xopIncludeType.setHandler(new XOPIncludeHandler(parentType, schema.getXopUnmarshaller()));
                ElementBinding xopInclude = new ElementBinding(schema, Constants.QNAME_XOP_INCLUDE, xopIncludeType);
                this.next = new ElementPosition(startName, new ParticleBinding(xopInclude));
                this.next.setStack(this.stack);
                this.next.setPrevious(this);
                return this.next;
            }
            QName typeName = parentType.getQName();
            throw new JBossXBRuntimeException((typeName == null ? "Anonymous" : typeName.toString()) + " type of element " + this.qName + " should be complex and contain " + startName + " as a child element.");
        }
        if (this.next != null) {
            if (this.particle.isOccurrenceAllowed(this.occurrence + 1)) {
                ++this.occurrence;
            } else {
                throw new JBossXBRuntimeException(startName + " cannot appear in this position. Expected content of " + this.qName + " is " + modelGroup);
            }
        }
        this.next = modelGroup.newPosition(startName, atts, typeParticle);
        if (this.next == null) {
            throw new JBossXBRuntimeException(startName + " not found as a child of " + this.qName + " in " + modelGroup);
        }
        this.next.setPrevious(this);
        this.flushIgnorableCharacters();
        Position nextPosition = this.next;
        while (nextPosition.getNext() != null) {
            if (nextPosition.getParticle().isRepeatable()) {
                nextPosition.startRepeatableParticle();
            }
            nextPosition.setStack(this.stack);
            nextPosition.initValue(atts);
            nextPosition.setParentType(parentType);
            nextPosition = nextPosition.getNext();
        }
        nextPosition.setStack(this.stack);
        nextPosition.setParentType(parentType);
        return (ElementPosition)nextPosition;
    }

    public void characters(char[] ch, int start, int length) {
        ElementBinding e = (ElementBinding)this.particle.getTerm();
        if (e.getType().isTextContentAllowed()) {
            if (this.indentation != Boolean.FALSE) {
                if (e.getType().isSimple()) {
                    this.indentation = Boolean.FALSE;
                    this.ignorableCharacters = false;
                } else if (e.getSchema() != null && !e.getSchema().isIgnoreWhitespacesInMixedContent()) {
                    this.indentation = Boolean.FALSE;
                    this.ignorableCharacters = false;
                } else {
                    for (int i = start; i < start + length; ++i) {
                        if (ch[i] == '\n') {
                            this.indentation = Boolean.TRUE;
                            continue;
                        }
                        if (Character.isWhitespace(ch[i])) continue;
                        this.indentation = Boolean.FALSE;
                        this.ignorableCharacters = false;
                        break;
                    }
                }
            }
            if (this.textContent == null) {
                this.textContent = new StringBuffer();
            }
            this.textContent.append(ch, start, length);
        }
    }

    public void endParticle() {
        block28: {
            Object parent;
            int i;
            ElementInterceptor interceptor;
            List localInterceptors;
            List<ElementInterceptor> interceptors;
            block27: {
                TermBinding parentTerm;
                block29: {
                    ParticleHandler wh;
                    ElementBinding element = (ElementBinding)this.particle.getTerm();
                    TypeBinding type = element.getType();
                    interceptors = null;
                    localInterceptors = null;
                    if (this.interceptorObjects != null) {
                        interceptors = element.getInterceptors();
                        List<Object> list = localInterceptors = this.parentType == null ? Collections.emptyList() : this.parentType.getInterceptors(this.qName);
                    }
                    if (this.o != SundayContentHandler.NIL) {
                        String textContent;
                        this.flushIgnorableCharacters();
                        TypeBinding charType = type.getSimpleType();
                        if (charType == null) {
                            charType = type;
                        }
                        CharactersHandler charHandler = this.ignoreCharacters ? null : charType.getCharactersHandler();
                        String string = textContent = this.textContent == null ? "" : this.textContent.toString();
                        if (textContent.length() > 0 || charHandler != null && !type.isIgnoreEmptyString()) {
                            Object unmarshalled;
                            String dataContent;
                            SchemaBinding schema = element.getSchema();
                            if (textContent.length() == 0) {
                                dataContent = null;
                            } else {
                                dataContent = textContent.toString();
                                if (schema != null && schema.isReplacePropertyRefs()) {
                                    dataContent = StringPropertyReplacer.replaceProperties((String)dataContent);
                                }
                                if (element.isNormalizeSpace()) {
                                    dataContent = dataContent.trim();
                                }
                            }
                            if (charHandler == null) {
                                if (!type.isSimple() && schema != null && schema.isStrictSchema() && !element.isSkip()) {
                                    throw new JBossXBRuntimeException("Element " + this.qName + " with type binding " + type.getQName() + " does not include text content binding: " + dataContent);
                                }
                                unmarshalled = dataContent;
                            } else {
                                CharactersMetaData charactersMetaData;
                                ValueMetaData valueMetaData = element.getValueMetaData();
                                if (valueMetaData == null && (charactersMetaData = type.getCharactersMetaData()) != null) {
                                    valueMetaData = charactersMetaData.getValue();
                                }
                                Object object = unmarshalled = dataContent == null ? charHandler.unmarshalEmpty(this.qName, charType, this.stack.getNamespaceRegistry(), valueMetaData) : charHandler.unmarshal(this.qName, charType, this.stack.getNamespaceRegistry(), valueMetaData, dataContent);
                            }
                            if (unmarshalled != null) {
                                if (this.o == null) {
                                    this.o = unmarshalled;
                                } else if (charHandler != null) {
                                    TermBeforeSetParentCallback beforeSetParent = charType.getBeforeSetParentCallback();
                                    if (beforeSetParent != null) {
                                        SundayContentHandler.UnmarshallingContextImpl ctx = this.stack.getContext();
                                        ctx.parent = this.o;
                                        ctx.particle = this.particle;
                                        ctx.parentParticle = this.notSkippedParent().getParticle();
                                        unmarshalled = beforeSetParent.beforeSetParent(unmarshalled, ctx);
                                        ctx.clear();
                                    }
                                    charHandler.setValue(this.qName, element, this.o, unmarshalled);
                                }
                            }
                            if (this.interceptorObjects != null) {
                                ElementInterceptor interceptor2;
                                int i2;
                                NamespaceRegistry nsRegistry = this.stack.getNamespaceRegistry();
                                int ioIndex = 0;
                                for (i2 = interceptors.size() - 1; i2 >= 0; --i2) {
                                    interceptor2 = interceptors.get(i2);
                                    interceptor2.characters(this.interceptorObjects[ioIndex++], this.qName, type, nsRegistry, dataContent);
                                }
                                for (i2 = localInterceptors.size() - 1; i2 >= 0; --i2) {
                                    interceptor2 = (ElementInterceptor)localInterceptors.get(i2);
                                    interceptor2.characters(this.interceptorObjects[ioIndex++], this.qName, type, nsRegistry, dataContent);
                                }
                            }
                        }
                    } else {
                        this.o = null;
                    }
                    this.o = this.handler.endParticle(this.o, this.qName, this.particle);
                    if (this.interceptorObjects != null && !interceptors.isEmpty()) {
                        int ioIndex = 0;
                        for (int i3 = interceptors.size() - 1; i3 >= 0; --i3) {
                            interceptor = interceptors.get(i3);
                            this.interceptorObjects[ioIndex] = interceptor.endElement(this.interceptorObjects[ioIndex++], this.qName, type);
                        }
                    }
                    if (this.interceptorObjects != null) break block27;
                    Position notSkippedParent = this.notSkippedParent();
                    if (notSkippedParent == null) break block28;
                    ParticleBinding parentParticle = notSkippedParent.getParticle();
                    parentTerm = parentParticle.getTerm();
                    if (notSkippedParent.getValue() == null) break block29;
                    ParticleHandler handler = this.handler;
                    if (parentTerm.isWildcard() && (wh = ((WildcardBinding)parentTerm).getWildcardHandler()) != null) {
                        handler = wh;
                    }
                    this.setParent(notSkippedParent, handler);
                    break block28;
                }
                if (!parentTerm.isWildcard()) break block28;
                Position parentPos = this.previous;
                parentPos.setValue(this.o);
                while (!parentPos.isElement()) {
                    parentPos = parentPos.getPrevious();
                    parentPos.setValue(this.o);
                }
                if (!trace) break block28;
                log.trace((Object)("Value of " + this.qName + " " + this.o + " is promoted as the value of its parent element."));
                break block28;
            }
            int ioIndex = 0;
            for (i = interceptors.size() - 1; i >= 0; --i) {
                interceptor = interceptors.get(i);
                parent = this.interceptorObjects[ioIndex++];
                interceptor.add(parent, this.o, this.qName);
                this.o = parent;
            }
            for (i = localInterceptors.size() - 1; i >= 0; --i) {
                interceptor = (ElementInterceptor)localInterceptors.get(i);
                parent = this.interceptorObjects[ioIndex++];
                interceptor.add(parent, this.o, this.qName);
                this.o = parent;
            }
        }
        this.ended = true;
    }

    public ElementPosition startParticle(QName startName, Attributes atts) {
        return (ElementPosition)this.nextPosition(startName, atts);
    }

    public void repeatForChild(Attributes atts) {
        throw new JBossXBRuntimeException("Failed to repeat parent for non-repeatable element: repeatable parent expected to be a model group but got element " + this.qName);
    }

    public void push(Attributes atts) {
        String nil;
        List<ElementInterceptor> interceptors;
        Object parent;
        TypeBinding type;
        ElementBinding element = (ElementBinding)this.particle.getTerm();
        String xsiType = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (xsiType != null) {
            String xsiTypeLocal;
            String xsiTypePrefix;
            int colon;
            if (trace) {
                log.trace((Object)(element.getQName() + " uses xsi:type " + xsiType));
            }
            if (this.nonXsiParticle == null) {
                this.nonXsiParticle = this.particle;
            }
            if ((colon = xsiType.indexOf(58)) == -1) {
                xsiTypePrefix = "";
                xsiTypeLocal = xsiType;
            } else {
                xsiTypePrefix = xsiType.substring(0, colon);
                xsiTypeLocal = xsiType.substring(colon + 1);
            }
            String xsiTypeNs = this.stack.getNamespaceRegistry().getNamespaceURI(xsiTypePrefix);
            QName xsiTypeQName = new QName(xsiTypeNs, xsiTypeLocal);
            SchemaBinding schemaBinding = element.getSchema();
            TypeBinding xsiTypeBinding = schemaBinding.getType(xsiTypeQName);
            if (xsiTypeBinding == null) {
                throw new JBossXBRuntimeException("Type binding not found for type " + xsiTypeQName + " specified with xsi:type for element " + this.qName);
            }
            ElementBinding xsiElement = new ElementBinding(schemaBinding, this.qName, xsiTypeBinding);
            xsiElement.setRepeatableHandler(element.getRepeatableHandler());
            this.particle = new ParticleBinding(xsiElement, this.particle.getMinOccurs(), this.particle.getMaxOccurs(), this.particle.getMaxOccursUnbounded());
        }
        if (this.occurrence == 1 && this.particle.isRepeatable()) {
            this.startRepeatableParticle();
        }
        if ((type = element.getType()) == null) {
            throw new JBossXBRuntimeException("No type for element " + element);
        }
        this.handler = type.getHandler();
        if (this.handler == null) {
            this.handler = DefaultHandlers.ELEMENT_HANDLER;
        }
        Object object = parent = this.previous == null ? null : this.previous.getValue();
        if (this.parentType != null && !(interceptors = this.parentType.getInterceptors(this.qName)).isEmpty()) {
            NamespaceRegistry nsRegistry = this.stack.getNamespaceRegistry();
            this.interceptorObjects = new Object[interceptors.size() + element.getInterceptors().size()];
            int ioIndex = this.interceptorObjects.length - 1;
            for (ElementInterceptor i : interceptors) {
                parent = i.startElement(parent, this.qName, type);
                i.attributes(parent, this.qName, type, atts, nsRegistry);
                this.interceptorObjects[ioIndex--] = parent;
            }
        }
        if (!element.getInterceptors().isEmpty()) {
            int ioIndex;
            NamespaceRegistry nsRegistry = this.stack.getNamespaceRegistry();
            if (this.interceptorObjects == null) {
                this.interceptorObjects = new Object[element.getInterceptors().size()];
                ioIndex = this.interceptorObjects.length - 1;
            } else {
                ioIndex = element.getInterceptors().size() - 1;
            }
            for (ElementInterceptor i : element.getInterceptors()) {
                parent = i.startElement(parent, this.qName, type);
                i.attributes(parent, this.qName, type, atts, nsRegistry);
                this.interceptorObjects[ioIndex--] = parent;
            }
        }
        if ((nil = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil")) == null || !"1".equals(nil) && !"true".equals(nil)) {
            this.initValue(atts);
        } else {
            this.o = SundayContentHandler.NIL;
        }
    }

    private void flushIgnorableCharacters() {
        if (this.textContent == null) {
            return;
        }
        if (this.indentation == Boolean.TRUE || this.ignorableCharacters) {
            if (trace) {
                log.trace((Object)("ignored characters: " + ((ElementBinding)this.particle.getTerm()).getQName() + " '" + this.textContent + "'"));
            }
            this.textContent = null;
            this.indentation = null;
        }
    }
}

