/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Field;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.Pos;
import org.jboss.logging.annotations.Property;
import org.jboss.logging.annotations.Suppressed;
import org.jboss.logging.annotations.Transform;
import org.jboss.logging.processor.apt.ParameterFactory;
import org.jboss.logging.processor.apt.ReturnTypeFactory;
import org.jboss.logging.processor.apt.ThrowableTypeFactory;
import org.jboss.logging.processor.model.LoggerMessageMethod;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.model.ReturnType;
import org.jboss.logging.processor.model.ThrowableType;
import org.jboss.logging.processor.util.ElementHelper;
import org.jboss.logging.processor.util.Expressions;
import org.jboss.logging.processor.util.Objects;

final class MessageMethodBuilder {
    private static final String MESSAGE_METHOD_SUFFIX = "$str";
    private final List<ExecutableElement> methods;
    private final ProcessingEnvironment processingEnv;
    private final Properties expressionProperties;

    private MessageMethodBuilder(ProcessingEnvironment processingEnv, Properties expressionProperties) {
        this.processingEnv = processingEnv;
        this.expressionProperties = expressionProperties;
        this.methods = new LinkedList<ExecutableElement>();
    }

    MessageMethodBuilder add(Collection<ExecutableElement> methods) {
        this.methods.addAll(methods);
        return this;
    }

    Set<MessageMethod> build() {
        Elements elements = this.processingEnv.getElementUtils();
        LinkedHashSet<AptMessageMethod> result = new LinkedHashSet<AptMessageMethod>();
        for (ExecutableElement elementMethod : this.methods) {
            AptMessageMethod resultMethod = MessageMethodBuilder.createMessageMethod(elements, elementMethod);
            resultMethod.inheritsMessage = this.inheritsMessage(this.methods, elementMethod);
            resultMethod.message = this.findMessage(this.methods, elementMethod);
            resultMethod.isOverloaded = this.isOverloaded(this.methods, elementMethod);
            for (TypeMirror typeMirror : elementMethod.getThrownTypes()) {
                resultMethod.thrownTypes.add(ThrowableTypeFactory.of(this.processingEnv, typeMirror));
            }
            for (Parameter parameter : ParameterFactory.of(this.processingEnv, resultMethod.method)) {
                resultMethod.add(parameter);
            }
            if (resultMethod.isOverloaded()) {
                resultMethod.messageMethodName = resultMethod.name() + resultMethod.formatParameterCount() + MESSAGE_METHOD_SUFFIX;
                resultMethod.translationKey = resultMethod.name() + "." + resultMethod.formatParameterCount();
            } else {
                resultMethod.messageMethodName = resultMethod.name() + MESSAGE_METHOD_SUFFIX;
                resultMethod.translationKey = resultMethod.name();
            }
            resultMethod.returnType = ReturnTypeFactory.of(this.processingEnv, elementMethod.getReturnType(), resultMethod);
            result.add(resultMethod);
        }
        return Collections.unmodifiableSet(result);
    }

    private MessageMethod.Message findMessage(Collection<ExecutableElement> methods, ExecutableElement method) {
        AptMessage result;
        block4: {
            Message message;
            block2: {
                block3: {
                    result = null;
                    message = method.getAnnotation(Message.class);
                    if (message == null) break block2;
                    result = new AptMessage(message, this.expressionProperties);
                    result.hasId = this.hasMessageId(message);
                    boolean bl = result.inheritsId = message.id() == -1;
                    if (!result.inheritsId()) break block3;
                    result.id = this.findMessageId(methods, method);
                    if (result.id <= 0) break block4;
                    result.hasId = true;
                    break block4;
                }
                result.id = message.id();
                break block4;
            }
            Collection<ExecutableElement> allMethods = this.findByName(methods, method);
            for (ExecutableElement m : allMethods) {
                message = m.getAnnotation(Message.class);
                if (message == null) continue;
                result = new AptMessage(message, this.expressionProperties);
                result.hasId = this.hasMessageId(message);
                boolean bl = result.inheritsId = message.id() == -1;
                if (result.inheritsId()) {
                    result.id = this.findMessageId(methods, m);
                    if (result.id <= 0) break;
                    result.hasId = true;
                    break;
                }
                result.id = message.id();
                break;
            }
        }
        return result;
    }

    private int findMessageId(Collection<ExecutableElement> methods, ExecutableElement method) {
        int result = -2;
        Collection<ExecutableElement> allMethods = this.findByName(methods, method.getSimpleName());
        for (ExecutableElement m : allMethods) {
            Message message = m.getAnnotation(Message.class);
            if (message == null || message.id() == -1) continue;
            result = message.id();
        }
        return result;
    }

    private boolean hasMessageId(Message message) {
        return message != null && message.id() != 0 && message.id() != -1;
    }

    private Collection<ExecutableElement> findByName(Collection<ExecutableElement> methods, ExecutableElement method) {
        Name methodName = method.getSimpleName();
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        int paramCount = this.parameterCount(method.getParameters());
        for (ExecutableElement m : methods) {
            if (!methodName.equals(m.getSimpleName()) || this.parameterCount(m.getParameters()) != paramCount) continue;
            result.add(m);
        }
        return result;
    }

    private Collection<ExecutableElement> findByName(Collection<ExecutableElement> methods, Name methodName) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            if (!methodName.equals(method.getSimpleName())) continue;
            result.add(method);
        }
        return result;
    }

    private boolean inheritsMessage(Collection<ExecutableElement> methods, ExecutableElement method) {
        if (ElementHelper.isAnnotatedWith(method, Message.class)) {
            return false;
        }
        Collection<ExecutableElement> allMethods = this.findByName(methods, method.getSimpleName());
        for (ExecutableElement m : allMethods) {
            if (!ElementHelper.isAnnotatedWith(m, Message.class)) continue;
            return true;
        }
        return false;
    }

    private boolean isOverloaded(Collection<ExecutableElement> methods, ExecutableElement method) {
        Collection<ExecutableElement> allMethods = this.findByName(methods, method.getSimpleName());
        for (ExecutableElement m : allMethods) {
            if (!method.getSimpleName().equals(m.getSimpleName()) || this.parameterCount(method.getParameters()) == this.parameterCount(m.getParameters())) continue;
            return true;
        }
        return false;
    }

    private int parameterCount(Collection<? extends VariableElement> params) {
        int result = params.size();
        boolean hasCause = false;
        for (VariableElement variableElement : params) {
            if (ElementHelper.isAnnotatedWith(variableElement, Param.class) || ElementHelper.isAnnotatedWith(variableElement, Field.class) || ElementHelper.isAnnotatedWith(variableElement, Property.class) || ElementHelper.isAnnotatedWith(variableElement, Suppressed.class)) {
                --result;
            }
            if (!ElementHelper.isAnnotatedWith(variableElement, Cause.class)) continue;
            hasCause = true;
        }
        return result - (hasCause ? 1 : 0);
    }

    static MessageMethodBuilder create(ProcessingEnvironment processingEnv) {
        return MessageMethodBuilder.create(processingEnv, new Properties());
    }

    static MessageMethodBuilder create(ProcessingEnvironment processingEnv, Properties expressionProperties) {
        return new MessageMethodBuilder(processingEnv, expressionProperties);
    }

    private static AptMessageMethod createMessageMethod(Elements elements, ExecutableElement elementMethod) {
        if (elementMethod.getAnnotation(LogMessage.class) == null) {
            return new AptMessageMethod(elements, elementMethod);
        }
        return new AptLoggerMessageMethod(elements, elementMethod);
    }

    private static class AptMessageMethod
    implements MessageMethod {
        final Elements elements;
        final Map<TypeMirror, Set<Parameter>> parameters;
        final Set<ThrowableType> thrownTypes;
        final ExecutableElement method;
        ReturnType returnType;
        Parameter cause;
        boolean inheritsMessage;
        boolean isOverloaded;
        MessageMethod.Message message;
        String messageMethodName;
        String translationKey;
        int formatParameterCount;

        AptMessageMethod(Elements elements, ExecutableElement method) {
            this.elements = elements;
            this.method = method;
            this.inheritsMessage = false;
            this.isOverloaded = false;
            this.parameters = new HashMap<TypeMirror, Set<Parameter>>();
            this.thrownTypes = new LinkedHashSet<ThrowableType>();
            this.formatParameterCount = 0;
        }

        void add(Parameter parameter) {
            if (parameter.isFormatParameter()) {
                this.formatParameterCount = parameter.isAnnotatedWith(Pos.class) ? (this.formatParameterCount += parameter.getAnnotation(Pos.class).value().length) : ++this.formatParameterCount;
            }
            if (this.parameters.containsKey(null)) {
                this.parameters.get(null).add(parameter);
            } else {
                LinkedHashSet<Parameter> any = new LinkedHashSet<Parameter>();
                any.add(parameter);
                this.parameters.put(null, any);
            }
            for (AnnotationMirror annotationMirror : parameter.getAnnotationMirrors()) {
                if (this.parameters.containsKey(annotationMirror.getAnnotationType())) {
                    this.parameters.get(annotationMirror.getAnnotationType()).add(parameter);
                    continue;
                }
                LinkedHashSet<Parameter> set = new LinkedHashSet<Parameter>();
                set.add(parameter);
                this.parameters.put(annotationMirror.getAnnotationType(), set);
            }
            if (parameter.isAnnotatedWith(Cause.class)) {
                this.cause = parameter;
            }
        }

        @Override
        public String name() {
            return this.method.getSimpleName().toString();
        }

        @Override
        public Set<Parameter> parameters() {
            if (this.parameters.containsKey(null)) {
                return Collections.unmodifiableSet(this.parameters.get(null));
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Parameter> parametersAnnotatedWith(Class<? extends Annotation> annotation) {
            TypeElement type = ElementHelper.toTypeElement(this.elements, annotation);
            return type != null && this.parameters.containsKey(type.asType()) ? Collections.unmodifiableSet(this.parameters.get(type.asType())) : Collections.emptySet();
        }

        @Override
        public ReturnType returnType() {
            return this.returnType;
        }

        @Override
        public Set<ThrowableType> thrownTypes() {
            return Collections.unmodifiableSet(this.thrownTypes);
        }

        @Override
        public MessageMethod.Message message() {
            return this.message;
        }

        @Override
        public boolean inheritsMessage() {
            return this.inheritsMessage;
        }

        @Override
        public String messageMethodName() {
            return this.messageMethodName;
        }

        @Override
        public String translationKey() {
            return this.translationKey;
        }

        @Override
        public boolean hasCause() {
            return this.cause != null;
        }

        @Override
        public boolean isOverloaded() {
            return this.isOverloaded;
        }

        @Override
        public Parameter cause() {
            return this.cause;
        }

        @Override
        public int formatParameterCount() {
            return this.formatParameterCount;
        }

        @Override
        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.name()).add(this.parameters()).add(this.returnType()).toHashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptMessageMethod)) {
                return false;
            }
            AptMessageMethod other = (AptMessageMethod)obj;
            return Objects.areEqual(this.name(), other.name()) && Objects.areEqual(this.parameters, this.parameters) && Objects.areEqual(this.returnType, other.returnType);
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("name", this.name()).add("returnType", this.returnType()).add("parameters", this.parameters()).toString();
        }

        @Override
        public ExecutableElement getDelegate() {
            return this.method;
        }

        @Override
        public int compareTo(MessageMethod o) {
            int result = this.name().compareTo(o.name());
            result = result != 0 ? result : this.returnType.name().compareTo(o.returnType().name());
            int n = result = result != 0 ? result : this.parameters().size() - o.parameters().size();
            if (result == 0) {
                Iterator<Parameter> params1 = this.parameters().iterator();
                Iterator<Parameter> params2 = o.parameters().iterator();
                while (params1.hasNext()) {
                    if (params2.hasNext()) {
                        Parameter param1 = params1.next();
                        Parameter param2 = params2.next();
                        result = param1.compareTo(param2);
                    } else {
                        result = 1;
                    }
                    if (result == 0) continue;
                    break;
                }
            }
            return result;
        }

        @Override
        public String getComment() {
            return this.elements.getDocComment(this.method);
        }
    }

    private static class AptMessage
    implements MessageMethod.Message {
        private final Message message;
        private final String messageValue;
        private int id;
        private boolean hasId;
        private boolean inheritsId;

        private AptMessage(Message message, Properties expressionProperties) {
            this.message = message;
            this.messageValue = expressionProperties.isEmpty() ? message.value() : Expressions.resolve(expressionProperties, message.value());
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public boolean hasId() {
            return this.hasId;
        }

        @Override
        public boolean inheritsId() {
            return this.inheritsId;
        }

        @Override
        public String value() {
            return this.messageValue;
        }

        @Override
        public Message.Format format() {
            return this.message.format();
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("hasId", this.hasId).add("id", this.id()).add("inheritsId", this.inheritsId).add("value", this.value()).add("formatType", this.format()).toString();
        }
    }

    private static class AptLoggerMessageMethod
    extends AptMessageMethod
    implements LoggerMessageMethod {
        AptLoggerMessageMethod(Elements elements, ExecutableElement method) {
            super(elements, method);
        }

        @Override
        public String loggerMethod() {
            switch (this.message.format()) {
                case MESSAGE_FORMAT: {
                    return "logv";
                }
                case NO_FORMAT: {
                    return "log";
                }
                case PRINTF: {
                    return "logf";
                }
            }
            return "log";
        }

        @Override
        public String logLevel() {
            LogMessage logMessage = this.method.getAnnotation(LogMessage.class);
            return logMessage.level().name();
        }

        @Override
        public boolean wrapInEnabledCheck() {
            if (!this.parametersAnnotatedWith(Transform.class).isEmpty()) {
                return true;
            }
            for (Parameter parameter : this.parameters()) {
                if (!parameter.isSubtypeOf(Supplier.class)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return Objects.ToStringBuilder.of(this).add("name", this.name()).add("returnType", this.returnType()).add("parameters", this.parameters()).add("loggerMethod", this.loggerMethod()).toString();
        }
    }
}

