/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.errormanager;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.ErrorManager;
import org.jboss.logmanager.StandardOutputStreams;

public final class OnlyOnceErrorManager
extends ErrorManager {
    private final AtomicBoolean called = new AtomicBoolean();

    @Override
    public void error(String msg, Exception ex, int code) {
        String codeStr;
        if (this.called.getAndSet(true)) {
            return;
        }
        switch (code) {
            case 3: {
                codeStr = "CLOSE_FAILURE";
                break;
            }
            case 2: {
                codeStr = "FLUSH_FAILURE";
                break;
            }
            case 5: {
                codeStr = "FORMAT_FAILURE";
                break;
            }
            case 0: {
                codeStr = "GENERIC_FAILURE";
                break;
            }
            case 4: {
                codeStr = "OPEN_FAILURE";
                break;
            }
            case 1: {
                codeStr = "WRITE_FAILURE";
                break;
            }
            default: {
                codeStr = "INVALID (" + code + ")";
            }
        }
        StandardOutputStreams.printError(ex, "LogManager error of type %s: %s%n", codeStr, msg);
    }
}

