/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class StackTraceFormatter {
    private static final String CAUSED_BY_CAPTION = "Caused by: ";
    private static final String SUPPRESSED_CAPTION = "Suppressed: ";
    private static final ThreadLocal<Boolean> ENTERED = new ThreadLocal();
    private final Set<Throwable> seen = Collections.newSetFromMap(new IdentityHashMap());
    private final StringBuilder builder;
    private final int suppressedDepth;
    private final boolean extended;
    private final Map<String, String> cache;
    private int suppressedCount;

    private StackTraceFormatter(StringBuilder builder, int suppressedDepth, boolean extended) {
        this.builder = builder;
        this.suppressedDepth = suppressedDepth;
        this.extended = extended;
        this.cache = extended ? new HashMap() : null;
    }

    static void renderStackTrace(StringBuilder builder, Throwable t, boolean extended, int suppressedDepth) {
        new StackTraceFormatter(builder, suppressedDepth, extended).renderStackTrace(t);
    }

    private void renderStackTrace(Throwable t) {
        Throwable ourCause;
        this.suppressedCount = 0;
        this.builder.append(": ").append(t);
        this.newLine();
        StackTraceElement[] stackTrace = t.getStackTrace();
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (this.extended) {
                this.renderExtended("", stackTraceElement);
                continue;
            }
            this.renderTrivial("", stackTraceElement);
        }
        if (this.suppressedDepth != 0) {
            for (Serializable serializable : t.getSuppressed()) {
                if (this.suppressedDepth >= 0 && this.suppressedDepth <= this.suppressedCount++) continue;
                this.renderStackTrace(stackTrace, (Throwable)serializable, SUPPRESSED_CAPTION, "\t");
            }
        }
        if ((ourCause = t.getCause()) != null) {
            this.renderStackTrace(stackTrace, ourCause, CAUSED_BY_CAPTION, "");
        }
    }

    private void renderStackTrace(StackTraceElement[] parentStack, Throwable child, String caption, String prefix) {
        if (this.seen.contains(child)) {
            this.builder.append("\t[CIRCULAR REFERENCE:").append(child).append(']');
            this.newLine();
        } else {
            Throwable ourCause;
            this.seen.add(child);
            StackTraceElement[] causeStack = child.getStackTrace();
            int m = causeStack.length - 1;
            for (int n = parentStack.length - 1; m >= 0 && n >= 0 && causeStack[m].equals(parentStack[n]); --m, --n) {
            }
            int framesInCommon = causeStack.length - 1 - m;
            this.builder.append(prefix).append(caption).append(child);
            this.newLine();
            for (int i = 0; i <= m; ++i) {
                if (this.extended) {
                    this.renderExtended(prefix, causeStack[i]);
                    continue;
                }
                this.renderTrivial(prefix, causeStack[i]);
            }
            if (framesInCommon != 0) {
                this.builder.append(prefix).append("\t... ").append(framesInCommon).append(" more");
                this.newLine();
            }
            if (this.suppressedDepth != 0) {
                for (Throwable se : child.getSuppressed()) {
                    if (this.suppressedDepth >= 0 && this.suppressedDepth <= this.suppressedCount++) continue;
                    this.renderStackTrace(causeStack, se, SUPPRESSED_CAPTION, prefix + "\t");
                }
            }
            if ((ourCause = child.getCause()) != null) {
                this.renderStackTrace(causeStack, ourCause, CAUSED_BY_CAPTION, prefix);
            }
        }
    }

    private void renderTrivial(String prefix, StackTraceElement element) {
        this.builder.append(prefix).append("\tat ").append(element);
        this.newLine();
    }

    private void renderExtended(String prefix, StackTraceElement element) {
        this.builder.append(prefix).append("\tat ").append(element);
        String className = element.getClassName();
        String cached = this.cache.get(className);
        if (cached != null) {
            this.builder.append(cached);
            this.newLine();
            return;
        }
        int dotIdx = className.lastIndexOf(46);
        if (dotIdx == -1) {
            this.newLine();
            return;
        }
        String packageName = className.substring(0, dotIdx);
        final Class<?> exceptionClass = StackTraceFormatter.guessClass(className);
        Package exceptionPackage = null;
        if (exceptionClass != null) {
            exceptionPackage = exceptionClass.getPackage();
        }
        if (exceptionPackage == null) {
            try {
                exceptionPackage = Package.getPackage(packageName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String packageVersion = null;
        if (exceptionPackage != null) {
            try {
                packageVersion = exceptionPackage.getImplementationVersion();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (packageVersion == null) {
                try {
                    packageVersion = exceptionPackage.getSpecificationVersion();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        URL resource = null;
        SecurityManager sm = System.getSecurityManager();
        final String classResourceName = className.replace('.', '/') + ".class";
        if (exceptionClass != null) {
            try {
                if (sm == null) {
                    CodeSource codeSource;
                    ProtectionDomain protectionDomain = exceptionClass.getProtectionDomain();
                    if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                        resource = codeSource.getLocation();
                    }
                } else {
                    resource = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                        @Override
                        public URL run() {
                            CodeSource codeSource;
                            ProtectionDomain protectionDomain = exceptionClass.getProtectionDomain();
                            if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                                return codeSource.getLocation();
                            }
                            return null;
                        }
                    });
                }
            }
            catch (Throwable protectionDomain) {
                // empty catch block
            }
            if (resource == null) {
                try {
                    final ClassLoader exceptionClassLoader = exceptionClass.getClassLoader();
                    resource = sm == null ? (exceptionClassLoader == null ? ClassLoader.getSystemResource(classResourceName) : exceptionClassLoader.getResource(classResourceName)) : AccessController.doPrivileged(new PrivilegedAction<URL>(){

                        @Override
                        public URL run() {
                            return exceptionClassLoader == null ? ClassLoader.getSystemResource(classResourceName) : exceptionClassLoader.getResource(classResourceName);
                        }
                    });
                }
                catch (Throwable exceptionClassLoader) {
                    // empty catch block
                }
            }
        }
        String jarName = StackTraceFormatter.getJarName(resource, classResourceName);
        boolean started = false;
        StringBuilder tagBuilder = new StringBuilder();
        if (jarName != null) {
            started = true;
            tagBuilder.append(" [").append(jarName).append(':');
        }
        if (packageVersion != null) {
            if (!started) {
                tagBuilder.append(" [:");
                started = true;
            }
            tagBuilder.append(packageVersion);
        }
        if (started) {
            tagBuilder.append(']');
            String tag = tagBuilder.toString();
            this.cache.put(className, tag);
            this.builder.append(tag);
        } else {
            this.cache.put(className, "");
        }
        this.newLine();
    }

    private void newLine() {
        this.builder.append(System.lineSeparator());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> guessClass(String name) {
        if (ENTERED.get() != null) {
            return null;
        }
        ENTERED.set(Boolean.TRUE);
        try {
            ClassLoader tccl2222222 = Thread.currentThread().getContextClassLoader();
            if (tccl2222222 != null) {
                Class<?> clazz = Class.forName(name, false, tccl2222222);
                ENTERED.remove();
                return clazz;
            }
        }
        catch (ClassNotFoundException tccl2222222) {
            // empty catch block
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException tccl2222222) {
            try {
                Class<?> tccl2222222 = Class.forName(name, false, null);
                ENTERED.remove();
                return tccl2222222;
            }
            catch (Throwable t) {
                return null;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    static String getJarName(URL resource, String classResourceName) {
        int endIdx;
        if (resource == null) {
            return null;
        }
        String path = resource.getPath();
        String protocol = resource.getProtocol();
        if ("jar".equals(protocol)) {
            int sepIdx = path.lastIndexOf("!/");
            if (sepIdx != -1) {
                String firstPart = path.substring(0, sepIdx);
                int lsIdx = Math.max(firstPart.lastIndexOf(47), firstPart.lastIndexOf(92));
                return firstPart.substring(lsIdx + 1);
            }
        } else if ("module".equals(protocol)) {
            return resource.getPath();
        }
        for (endIdx = path.lastIndexOf(classResourceName); endIdx >= 0; --endIdx) {
            char ch = path.charAt(endIdx);
            if (ch != '/' && ch != '\\' && ch != '?') continue;
            String firstPart = path.substring(0, endIdx);
            int lsIdx = Math.max(firstPart.lastIndexOf(47), firstPart.lastIndexOf(92));
            return firstPart.substring(lsIdx + 1);
        }
        endIdx = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        return path.substring(endIdx + 1);
    }
}

