/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.plugins.factory;

import java.util.HashMap;
import java.util.Map;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.RunState;
import org.jboss.managed.api.RunStateMapper;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringRunStateMapper
implements RunStateMapper {
    private Map<String, String> valueMapping = new HashMap<String, String>();

    public StringRunStateMapper() {
    }

    public StringRunStateMapper(String[] valueStrings, String[] enumStrings) {
        for (int n = 0; n < valueStrings.length; ++n) {
            String value = valueStrings[n];
            String enums = enumStrings[n];
            this.valueMapping.put(value, enums);
        }
    }

    public Map<String, String> getValueMapping() {
        return this.valueMapping;
    }

    public void setValueMapping(Map<String, String> valueMapping) {
        this.valueMapping = valueMapping;
    }

    @Override
    public RunState getRunState(ManagedProperty property, MetaValue value) {
        RunState state = RunState.UNKNOWN;
        if (value.getMetaType().isSimple()) {
            SimpleValue sv = (SimpleValue)SimpleValue.class.cast(value);
            String s = sv.getValue().toString();
            String es = this.valueMapping.get(s);
            if (es != null) {
                state = RunState.valueOf(es);
            }
        } else if (value.getMetaType().isEnum()) {
            // empty if block
        }
        return state;
    }
}

