/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AbstractWithDescriptionsParser;
import org.jboss.metadata.ejb.parser.spec.AttributeProcessor;
import org.jboss.metadata.ejb.parser.spec.AttributeProcessorHelper;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.parser.spec.IdMetaDataAttributeProcessor;
import org.jboss.metadata.ejb.parser.spec.MethodParametersMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.UnexpectedAttributeProcessor;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.javaee.support.IdMetaData;
import org.jboss.metadata.property.PropertyReplacer;

public class MethodMetaDataParser
extends AbstractWithDescriptionsParser<MethodMetaData> {
    private static final AttributeProcessor<IdMetaData> ATTRIBUTE_PROCESSOR = new IdMetaDataAttributeProcessor<Object>(UnexpectedAttributeProcessor.instance());
    public static final MethodMetaDataParser INSTANCE = new MethodMetaDataParser();

    @Override
    public MethodMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        MethodMetaData methodMetaData = new MethodMetaData();
        AttributeProcessorHelper.processAttributes(methodMetaData, reader, ATTRIBUTE_PROCESSOR);
        this.processElements(methodMetaData, reader, propertyReplacer);
        return methodMetaData;
    }

    @Override
    protected void processElement(MethodMetaData methodMetaData, XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
        switch (ejbJarElement) {
            case EJB_NAME: {
                String ejbName = MethodMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                methodMetaData.setEjbName(ejbName);
                return;
            }
            case METHOD_NAME: {
                String methodName = MethodMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                methodMetaData.setMethodName(methodName);
                return;
            }
            case METHOD_PARAMS: {
                MethodParametersMetaData methodParams = MethodParametersMetaDataParser.INSTANCE.parse(reader, propertyReplacer);
                methodMetaData.setMethodParams(methodParams);
                return;
            }
            case METHOD_INTF: {
                String methodIntfValue = MethodMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                if (methodIntfValue == null || methodIntfValue.isEmpty()) {
                    throw MethodMetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)new Exception("Unexpected null or empty value for method-intf element"));
                }
                MethodInterfaceType methodIntf = MethodInterfaceType.valueOf(methodIntfValue);
                methodMetaData.setMethodIntf(methodIntf);
                return;
            }
        }
        super.processElement(methodMetaData, reader, propertyReplacer);
    }
}

