/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import org.jboss.modules.Dependency;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleDependency;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.ClassFilter;
import org.jboss.modules.filter.PathFilter;

public final class ModuleDependencySpec
extends DependencySpec {
    private final ModuleLoader moduleLoader;
    private final ModuleIdentifier identifier;
    private final boolean optional;

    ModuleDependencySpec(PathFilter importFilter, PathFilter exportFilter, PathFilter resourceImportFilter, PathFilter resourceExportFilter, ClassFilter classImportFilter, ClassFilter classExportFilter, ModuleLoader moduleLoader, ModuleIdentifier identifier, boolean optional) {
        super(importFilter, exportFilter, resourceImportFilter, resourceExportFilter, classImportFilter, classExportFilter);
        this.moduleLoader = moduleLoader;
        this.identifier = identifier;
        this.optional = optional;
    }

    @Override
    Dependency getDependency(Module module) {
        ModuleLoader loader = this.moduleLoader;
        return new ModuleDependency(this.exportFilter, this.importFilter, this.resourceExportFilter, this.resourceImportFilter, this.classExportFilter, this.classImportFilter, loader == null ? module.getModuleLoader() : loader, this.identifier, this.optional);
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String toString() {
        return "dependency on " + this.identifier;
    }
}

