/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.txoj.abstractrecords;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.txoj.LockManager;
import com.arjuna.ats.txoj.logging.txojLogger;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LockRecord
extends AbstractRecord {
    protected BasicAction actionHandle;
    private LockManager managerAddress;
    private boolean readOnly;
    private String managerType;

    public LockRecord(LockManager lm, BasicAction currAct) {
        this(lm, false, currAct);
    }

    public LockRecord(LockManager lm, boolean rdOnly, BasicAction currAct) {
        super(lm.get_uid(), lm.type(), 1);
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockRecord::LockRecord(" + String.valueOf(lm.get_uid()) + ", " + (rdOnly ? "PREPARE_READONLY" : "WRITEABLE") + ")"));
        }
        this.actionHandle = currAct;
        this.managerAddress = lm;
        this.readOnly = rdOnly;
        this.managerType = lm.type();
    }

    public int typeIs() {
        return 121;
    }

    public Object value() {
        return this.managerAddress;
    }

    public void setValue(Object o) {
        txojLogger.i18NLogger.warn_LockRecord_1();
    }

    public int nestedAbort() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockRecord::nestedAbort() for " + String.valueOf(this.order())));
        }
        if (this.managerAddress == null) {
            return 8;
        }
        if (this.actionHandle != null) {
            Uid toRelease = this.actionHandle.get_uid();
            this.actionHandle = this.actionHandle.parent();
            if (!this.managerAddress.releaseAll(toRelease)) {
                txojLogger.i18NLogger.warn_LockRecord_2(toRelease);
                return 8;
            }
        } else {
            txojLogger.i18NLogger.warn_LockRecord_3();
        }
        return 7;
    }

    public int nestedCommit() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockRecord::nestedCommit() for " + String.valueOf(this.order())));
        }
        if (this.managerAddress == null) {
            return 8;
        }
        if (this.actionHandle != null) {
            Uid toRelease = this.actionHandle.get_uid();
            this.actionHandle = this.actionHandle.parent();
            return this.managerAddress.propagate(toRelease, this.actionHandle.get_uid()) ? 7 : 8;
        }
        txojLogger.i18NLogger.warn_LockRecord_4();
        return 8;
    }

    public int nestedPrepare() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockRecord::nestedPrepare() for " + String.valueOf(this.order())));
        }
        return 0;
    }

    public int topLevelAbort() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockRecord::topLevelAbort() for " + String.valueOf(this.order())));
        }
        return this.nestedAbort();
    }

    public int topLevelCommit() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockRecord::topLevelCommit() for " + String.valueOf(this.order())));
        }
        if (this.managerAddress == null) {
            return 8;
        }
        if (this.actionHandle != null) {
            if (!this.managerAddress.releaseAll(this.actionHandle.get_uid())) {
                txojLogger.i18NLogger.warn_LockRecord_5(this.actionHandle.get_uid());
                return 8;
            }
        } else {
            txojLogger.i18NLogger.warn_LockRecord_6();
            return 8;
        }
        return 7;
    }

    public int topLevelPrepare() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockRecord::topLevelPrepare() for " + String.valueOf(this.order())));
        }
        if (this.readOnly) {
            if (this.topLevelCommit() == 7) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringWriter strm = new StringWriter();
        this.print(new PrintWriter(strm));
        return strm.toString();
    }

    public void print(PrintWriter strm) {
        super.print(strm);
        strm.println("LockRecord");
    }

    public boolean restore_state(InputObjectState o, int t) {
        txojLogger.i18NLogger.warn_LockRecord_7(this.type(), this.order());
        return false;
    }

    public boolean save_state(OutputObjectState o, int t) {
        return true;
    }

    public String type() {
        return "/StateManager/AbstractRecord/LockRecord";
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final String lockType() {
        return this.managerType;
    }

    public void merge(AbstractRecord a) {
    }

    public void alter(AbstractRecord a) {
    }

    public boolean shouldAdd(AbstractRecord a) {
        return false;
    }

    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    public boolean shouldReplace(AbstractRecord ar) {
        return this.order().equals(ar.order()) && this.typeIs() == ar.typeIs() && ((LockRecord)ar).isReadOnly() && !this.readOnly;
    }

    public LockRecord() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)"LockRecord::LockRecord()");
        }
        this.actionHandle = null;
        this.managerAddress = null;
        this.readOnly = false;
        this.managerType = null;
    }
}

