/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.tools.osb.mbean.OSEntryBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBrowser;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.management.MBeanException;

@Deprecated
public class UidWrapper {
    private static final ThreadLocal<String> recordWrapperTypeName = new ThreadLocal();
    private String name;
    private final ObjStoreBrowser browser;
    private final String browserMBeanName;
    private final String beantype;
    private final String className;
    private final String ostype;
    private final Uid uid;
    private long tstamp;
    private OSEntryBean mbean;
    boolean registered = false;
    boolean allowRegistration;

    public static void setRecordWrapperTypeName(String name) {
        recordWrapperTypeName.set(name);
    }

    public static String getRecordWrapperTypeName() {
        return recordWrapperTypeName.get();
    }

    public UidWrapper(Uid uid) {
        this(null, "", "", null, uid);
    }

    public UidWrapper(ObjStoreBrowser browser, String beantype, String ostype, String className, Uid uid) {
        this(browser, beantype, ostype, className, uid, true);
    }

    public UidWrapper(ObjStoreBrowser browser, String beantype, String ostype, String className, Uid uid, boolean allowRegistration) {
        this.browser = browser;
        this.ostype = ostype;
        this.beantype = beantype;
        this.className = className;
        this.uid = uid;
        this.tstamp = 0L;
        this.browserMBeanName = browser != null ? browser.getObjStoreBrowserMBeanName() : arjPropertyManager.getObjectStoreEnvironmentBean().getJmxToolingMBeanName();
        this.name = this.browserMBeanName + ",itype=" + ostype + ",uid=" + uid.fileStringForm();
        this.registered = false;
        this.allowRegistration = allowRegistration;
    }

    public OSEntryBean getMBean() {
        return this.mbean;
    }

    public void probe() throws MBeanException {
        if (this.browser != null) {
            this.browser.probe();
        }
    }

    public String getType() {
        return this.ostype;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassName() {
        return this.className;
    }

    void register() {
        if (this.allowRegistration && this.mbean != null && !this.registered) {
            this.mbean.register();
            this.registered = true;
        }
    }

    public void unregister() {
        if (this.registered && this.mbean != null) {
            try {
                this.mbean.unregister();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.registered = false;
        }
    }

    public long getTimestamp() {
        return this.tstamp;
    }

    public void setTimestamp(long tstamp) {
        this.tstamp = tstamp;
    }

    public Uid getUid() {
        return this.uid;
    }

    public ObjStoreBrowser getBrowser() {
        return this.browser;
    }

    public String getBrowserMBeanName() {
        return this.browserMBeanName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UidWrapper that = (UidWrapper)o;
        return !(this.uid == null ? that.uid != null : !this.uid.equals(that.uid));
    }

    public int hashCode() {
        return this.uid != null ? this.uid.hashCode() : 0;
    }

    public String toString() {
        return "UidWrapper{ostype='" + this.ostype + "', uid=" + this.uid + ", tstamp=" + this.tstamp + "}";
    }

    public StringBuilder toString(String prefix, StringBuilder sb) {
        return this.mbean == null ? sb : this.mbean.toString(prefix, sb);
    }

    public List<UidWrapper> probe(String type) {
        return this.browser.probe(type);
    }

    public OSEntryBean createMBean() {
        try {
            Class<?> cl = Class.forName(this.beantype);
            Constructor<?> constructor = cl.getConstructor(UidWrapper.class);
            this.mbean = (OSEntryBean)constructor.newInstance(this);
        }
        catch (Throwable e) {
            tsLogger.i18NLogger.warn_osb_MBeanCtorFail(e);
            this.mbean = new OSEntryBean(this);
        }
        this.mbean.activate();
        return this.mbean;
    }

    public void createAndRegisterMBean() {
        if (this.mbean == null) {
            this.createMBean();
        }
        this.register();
    }

    public boolean isAllowRegistration() {
        return this.allowRegistration;
    }

    public void setAllowRegistration(boolean allowRegistration) {
        this.allowRegistration = allowRegistration;
    }
}

